/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.graph;

import com.lvonce.wind.task.context.ContextSaver;
import com.lvonce.wind.task.context.FlowContext;
import com.lvonce.wind.task.context.GraphContext;
import com.lvonce.wind.task.engine.TaskEngine;
import com.lvonce.wind.task.enums.FlowState;
import com.lvonce.wind.task.enums.TaskSeq;
import com.lvonce.wind.task.enums.TaskState;
import com.lvonce.wind.task.event.FlowEvent;
import com.lvonce.wind.task.event.RouteEvent;
import com.lvonce.wind.task.event.TaskEvent;
import com.lvonce.wind.task.event.TaskRoutedEvent;
import com.lvonce.wind.task.tasks.SagaTask;

public interface FlowGraph<T, R> {
    public GraphContext getGraphContext();

    public TaskEngine<?> getTaskEngine();

    default public ContextSaver getContextSaver() {
        return new ContextSaver.EmptyContextSaver();
    }

    default public FlowEvent<R> confirm(FlowContext context) {
        Object data = context.peekEvent().getTaskevent().getData();
        return FlowEvent.of(FlowState.SUCCESS, data);
    }

    default public FlowEvent<R> cancel(FlowContext context) {
        return FlowEvent.ofFail();
    }

    default public FlowEvent<R> run(T dataEvent) {
        int startTask = this.getGraphContext().getStart();
        RouteEvent routeEvent = RouteEvent.of(startTask, startTask);
        TaskEvent<T> taskEvent = TaskEvent.of(dataEvent);
        TaskRoutedEvent<T> inEvent = TaskRoutedEvent.of(taskEvent, routeEvent);
        FlowContext context = new FlowContext();
        context.pushEvent(inEvent);
        return this.execute(context);
    }

    default public FlowEvent<R> rollback(FlowContext context) {
        while (!context.getPath().isEmpty()) {
            TaskEvent<?> taskEvent;
            TaskRoutedEvent<?> inEvent = context.peekEvent();
            int currTaskSeq = inEvent.getRouteevent().getNextTaskSeq();
            String taskUuid = this.getGraphContext().getTaskUuidMap().get(currTaskSeq);
            SagaTask task = (SagaTask)this.getTaskEngine().getTask(taskUuid);
            TaskEvent<?> cancelResult = task.rollback(taskEvent = inEvent.getTaskevent());
            TaskState cancelState = cancelResult.getState();
            if (!cancelState.equals((Object)TaskState.FAIL)) {
                return FlowEvent.ofFail();
            }
            context.popEvent();
        }
        return FlowEvent.ofFail();
    }

    default public FlowEvent<R> execute(FlowContext context) {
        int nextTaskSeq;
        TaskRoutedEvent<?> currentEvent = context.peekEvent();
        GraphContext graphContext = this.getGraphContext();
        do {
            TaskEvent<?> inEvent;
            RouteEvent flowEvent = currentEvent.getRouteevent();
            int currTaskSeq = flowEvent.getNextTaskSeq();
            String taskUuid = graphContext.getTaskUuidMap().get(currTaskSeq);
            Object task = this.getTaskEngine().getTask(taskUuid);
            TaskEvent<?> outEvent = task.run(context, inEvent = currentEvent.getTaskevent());
            if (!outEvent.getState().isFinish()) {
                return FlowEvent.ofPending();
            }
            TaskRoutedEvent<?> resultEvent = graphContext.route(currTaskSeq, outEvent);
            nextTaskSeq = resultEvent.getRouteevent().getNextTaskSeq();
            if (TaskSeq.isAbort(nextTaskSeq)) {
                return FlowEvent.ofAbort();
            }
            if (TaskSeq.isFail(nextTaskSeq)) {
                context.popEvent();
                return this.cancel(context);
            }
            context.pushResult(resultEvent);
            currentEvent = resultEvent;
        } while (!TaskSeq.isEnd(nextTaskSeq));
        context.finish();
        return this.confirm(context);
    }
}

