/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.graph;

import com.lvonce.wind.task.context.FlowContext;
import com.lvonce.wind.task.context.GraphContext;
import com.lvonce.wind.task.engine.TccTaskEngine;
import com.lvonce.wind.task.enums.FlowState;
import com.lvonce.wind.task.enums.TaskState;
import com.lvonce.wind.task.event.FlowEvent;
import com.lvonce.wind.task.event.TaskEvent;
import com.lvonce.wind.task.event.TaskRoutedEvent;
import com.lvonce.wind.task.graph.FlowGraph;
import com.lvonce.wind.task.tasks.Task;
import java.util.ArrayList;

public class TccFlowGraph<T, R>
implements FlowGraph<T, R> {
    private final GraphContext graphContext;
    private final TccTaskEngine taskEngine;

    @Override
    public FlowEvent<R> cancel(FlowContext context) {
        return this.rollback(context);
    }

    @Override
    public FlowEvent<R> confirm(FlowContext context) {
        ArrayList<TaskRoutedEvent<?>> path = context.getPath();
        int size = context.getPath().size();
        for (int i = 0; i < size - 1; ++i) {
            TaskEvent<?> taskEvent;
            TaskRoutedEvent<?> inEvent = path.get(i);
            int currTaskSeq = inEvent.getRouteevent().getNextTaskSeq();
            String taskUuid = this.graphContext.getTaskUuidMap().get(currTaskSeq);
            Task task = this.taskEngine.getTask(taskUuid);
            TaskEvent<?> confirmResult = task.commit(taskEvent = inEvent.getTaskevent());
            TaskState confirmState = confirmResult.getState();
            if (confirmState.equals((Object)TaskState.SUCCESS)) continue;
            return FlowEvent.ofPending();
        }
        Object data = context.peekEvent().getTaskevent().getData();
        return FlowEvent.of(FlowState.SUCCESS, data);
    }

    @Override
    public GraphContext getGraphContext() {
        return this.graphContext;
    }

    public TccTaskEngine getTaskEngine() {
        return this.taskEngine;
    }

    public TccFlowGraph(GraphContext graphContext, TccTaskEngine taskEngine) {
        this.graphContext = graphContext;
        this.taskEngine = taskEngine;
    }
}

