/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.util;

import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyUtil {
    private static final Logger log = LoggerFactory.getLogger(GroovyUtil.class);
    private static final GroovyClassLoader groovyClassLoader;

    private static ImportCustomizer buildImportCustomer() {
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addImport("SqlStatement", "com.lvonce.wind.sql.transaction.statment.SqlStatement");
        customizer.addImport("HttpRequestBody", "com.lvonce.wind.http.HttpRequestBody");
        customizer.addImport("HttpRequest", "com.lvonce.wind.http.HttpRequest");
        customizer.addImport("HttpResponse", "com.lvonce.wind.http.HttpResponse");
        customizer.addImport("RestSqlContext", "com.lvonce.wind.RestSqlContext");
        customizer.addImport("RestSqlFunction", "com.lvonce.wind.RestSqlFunction");
        customizer.addStaticStars(new String[]{"java.lang.Math"});
        return customizer;
    }

    private static SecureASTCustomizer buildCustomizer() {
        SecureASTCustomizer customizer = new SecureASTCustomizer();
        return customizer;
    }

    public static Class<?> parseClass(String content) {
        try {
            return groovyClassLoader.parseClass(content);
        }
        catch (CompilationFailedException ex) {
            log.error("error: ", (Throwable)ex);
            return null;
        }
    }

    static {
        CompilerConfiguration config = new CompilerConfiguration();
        SecureASTCustomizer customizer = GroovyUtil.buildCustomizer();
        ImportCustomizer importCustomizer = GroovyUtil.buildImportCustomer();
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        groovyClassLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
    }
}

