/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.validator;

import com.lvonce.wind.validator.Validator;
import java.util.regex.Pattern;

public class EmailValidator
implements Validator {
    static String emailPattern = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\.][A-Za-z]{2,3}([\\.][A-Za-z]{2})?$";
    ThreadLocal<Pattern> pattern = ThreadLocal.withInitial(() -> Pattern.compile(emailPattern));
    private String val;

    @Override
    public Validator.ValidateResult accept(Object val) {
        if (val instanceof String) {
            this.val = (String)val;
            return Validator.ValidateResult.ofSuccess();
        }
        return Validator.ValidateResult.ofFailure("need String type");
    }

    @Override
    public Validator.ValidateResult validate() {
        if (this.val == null) {
            return Validator.ValidateResult.ofFailure("null value");
        }
        return Validator.ValidateResult.ofResult(this.pattern.get().matcher(this.val).matches(), this.val + " is not a valid email");
    }
}

