/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.validator;

import com.lvonce.wind.validator.Validator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnumStrValidator
implements Validator {
    private final Set<String> enumStrSet = new LinkedHashSet<String>();
    private final boolean ignoreCase;
    private final String nullAsStr;
    private String val;

    public EnumStrValidator(String ... stringList) {
        this.enumStrSet.addAll(Arrays.asList(stringList));
        this.ignoreCase = false;
        this.nullAsStr = "";
    }

    public EnumStrValidator(String[] stringList, boolean ignoreCase, String nullAsStr) {
        this.enumStrSet.addAll(Arrays.asList(stringList));
        this.ignoreCase = ignoreCase;
        this.nullAsStr = nullAsStr;
    }

    @Override
    public Validator.ValidateResult accept(Object val) {
        if (val instanceof String) {
            this.val = (String)val;
            return Validator.ValidateResult.ofSuccess();
        }
        return Validator.ValidateResult.ofFailure("need String type");
    }

    @Override
    public Validator.ValidateResult validate() {
        String val;
        String string = val = this.val == null ? this.nullAsStr : this.val;
        if (this.ignoreCase) {
            for (String str : this.enumStrSet) {
                if (!str.equalsIgnoreCase(val)) continue;
                return Validator.ValidateResult.ofSuccess();
            }
        } else {
            for (String str : this.enumStrSet) {
                if (!str.equals(val)) continue;
                return Validator.ValidateResult.ofSuccess();
            }
        }
        return Validator.ValidateResult.ofFailure(val + "is not any of the enum string");
    }
}

