/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.validator;

import com.lvonce.wind.validator.Validator;

public class LengthValidator
implements Validator {
    private final int minLength;
    private final boolean minExclusive;
    private final int maxLength;
    private final boolean maxExclusive;
    private String val;

    public LengthValidator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.minExclusive = false;
        this.maxLength = maxLength;
        this.maxExclusive = false;
    }

    public LengthValidator(int minLength, boolean minExclusive, int maxLength, boolean maxExclusive) {
        this.minLength = minLength;
        this.minExclusive = minExclusive;
        this.maxLength = maxLength;
        this.maxExclusive = maxExclusive;
    }

    @Override
    public Validator.ValidateResult accept(Object val) {
        if (val instanceof String) {
            this.val = (String)val;
            return Validator.ValidateResult.ofSuccess();
        }
        return Validator.ValidateResult.ofFailure("need String type");
    }

    @Override
    public Validator.ValidateResult validate() {
        if (this.val == null) {
            return Validator.ValidateResult.ofResult(this.minLength == 0 && !this.minExclusive, "string should not be null");
        }
        int len = this.val.length();
        int maxDiff = len - this.maxLength;
        if (maxDiff > 0) {
            return Validator.ValidateResult.ofFailure("string length is greater than max value [" + this.maxLength + "]");
        }
        if (maxDiff == 0 && this.maxExclusive) {
            return Validator.ValidateResult.ofFailure("string length must lower than max value [" + this.maxLength + "]");
        }
        int minDiff = len - this.minLength;
        if (minDiff < 0) {
            return Validator.ValidateResult.ofFailure("string length is lower than min value [" + this.minLength + "]");
        }
        if (minDiff == 0 && this.minExclusive) {
            return Validator.ValidateResult.ofFailure("string length must greater than min value [" + this.minLength + "]");
        }
        return Validator.ValidateResult.ofSuccess();
    }
}

