/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.validator;

import com.lvonce.wind.validator.Validator;

public class MinMaxRange<T extends Comparable<T>>
implements Validator {
    private final T max;
    private final boolean maxExclusive;
    private final T min;
    private final boolean minExclusive;
    private T val;

    public MinMaxRange(T min, T max) {
        this.min = min;
        this.max = max;
        this.minExclusive = false;
        this.maxExclusive = false;
    }

    public MinMaxRange(T min, boolean minExclusive, T max, boolean maxExclusive) {
        this.min = min;
        this.minExclusive = minExclusive;
        this.max = max;
        this.maxExclusive = maxExclusive;
    }

    @Override
    public Validator.ValidateResult accept(Object val) {
        if (val instanceof Comparable) {
            this.val = (Comparable)val;
            return Validator.ValidateResult.ofSuccess();
        }
        return Validator.ValidateResult.ofFailure("need comparable type");
    }

    @Override
    public Validator.ValidateResult validate() {
        if (this.val == null) {
            return Validator.ValidateResult.ofFailure("null value");
        }
        int maxDiff = this.val.compareTo(this.max);
        if (maxDiff > 0) {
            return Validator.ValidateResult.ofFailure("value is greater than max value [" + this.val.toString() + "]");
        }
        if (maxDiff == 0 && this.maxExclusive) {
            return Validator.ValidateResult.ofFailure("value must lower than max value [" + this.val.toString() + "]");
        }
        int minDiff = this.val.compareTo(this.min);
        if (minDiff < 0) {
            return Validator.ValidateResult.ofFailure("value is lower than min value [" + this.val.toString() + "]");
        }
        if (minDiff == 0 && this.minExclusive) {
            return Validator.ValidateResult.ofFailure("value must greater than max value [" + this.val.toString() + "]");
        }
        return Validator.ValidateResult.ofSuccess();
    }
}

