/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.validator;

public interface Validator {
    public ValidateResult accept(Object var1);

    public ValidateResult validate();

    public static class ValidateResult {
        boolean success;
        String errMsg;

        private ValidateResult(boolean success, String errMsg) {
            this.success = success;
            this.errMsg = "Validate Error: " + errMsg;
        }

        public static ValidateResult ofSuccess() {
            return new ValidateResult(true, null);
        }

        public static ValidateResult ofFailure(String errMsg) {
            return new ValidateResult(false, errMsg);
        }

        public static ValidateResult ofResult(boolean success, String errMsg) {
            if (success) {
                return ValidateResult.ofSuccess();
            }
            return ValidateResult.ofFailure(errMsg);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrMsg() {
            return this.errMsg;
        }
    }
}

