/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.watcher;

import com.lvonce.wind.Pair;
import com.lvonce.wind.watcher.DirFileFilter;
import com.lvonce.wind.watcher.DirHandler;
import com.lvonce.wind.watcher.DirSingleFileFilter;
import com.lvonce.wind.watcher.FileHandler;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWatcher {
    private static final Logger log = LoggerFactory.getLogger(DirWatcher.class);
    private final Map<String, Pair<DirWatchItem, DirectoryWatcher>> dirWatcherMap = new LinkedHashMap<String, Pair<DirWatchItem, DirectoryWatcher>>();
    private final Map<String, Pair<FileWatchItem, DirectoryWatcher>> fileWatcherMap = new LinkedHashMap<String, Pair<FileWatchItem, DirectoryWatcher>>();

    public void clearDirWatcher(String uri) throws IOException {
        Pair<DirWatchItem, DirectoryWatcher> oldWatcher = this.dirWatcherMap.get(uri);
        if (oldWatcher != null) {
            oldWatcher.getSecond().close();
            this.dirWatcherMap.remove(uri);
        }
    }

    public void clearFileWatcher(String uri) throws IOException {
        Pair<FileWatchItem, DirectoryWatcher> oldWatcher = this.fileWatcherMap.get(uri);
        if (oldWatcher != null) {
            oldWatcher.getSecond().close();
            this.fileWatcherMap.remove(uri);
        }
    }

    private List<File> scanFiles(File file) {
        return (List)FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    public void watchFile(String uri, FileWatchItem watchItem) throws Exception {
        try {
            this.clearFileWatcher(uri);
            List<File> originFileList = this.scanFiles(watchItem.path.toFile());
            File originFile = watchItem.fileFilter.filter(originFileList);
            watchItem.getCreateHandler().handle(originFile);
            DirectoryChangeListener listener = event -> {
                try {
                    File file = event.path().toFile();
                    log.info("change event: {}", (Object)file.getCanonicalPath());
                    if (!watchItem.fileFilter.pass(file)) {
                        return;
                    }
                    log.info("change event passed: {}", (Object)file.getCanonicalPath());
                    switch (event.eventType()) {
                        case CREATE: {
                            watchItem.getCreateHandler().handle(file);
                            break;
                        }
                        case MODIFY: {
                            watchItem.getUpdateHandler().handle(file);
                            break;
                        }
                        case DELETE: {
                            watchItem.getDeleteHandler().handle(file);
                        }
                    }
                }
                catch (Exception ex) {
                    log.error(ex.getMessage());
                }
            };
            DirectoryWatcher watcher = DirectoryWatcher.builder().path(watchItem.path).listener(listener).build();
            watcher.watchAsync();
            this.fileWatcherMap.put(uri, Pair.of(watchItem, watcher));
        }
        catch (Exception ex) {
            log.error("watchFile error: {}", (Object)ex.getMessage());
        }
    }

    public void watchDir(String uri, DirWatchItem watchItem) throws Exception {
        this.clearDirWatcher(uri);
        List<File> originFileList = this.scanFiles(watchItem.path.toFile());
        List<File> fileList = watchItem.fileFilter.filter(originFileList);
        watchItem.getCreateHandler().handle(fileList);
        DirectoryChangeListener listener = event -> {
            try {
                Path path = watchItem.path;
                File file = path.toFile();
                List<File> originFiles = this.scanFiles(file);
                List<File> files = watchItem.fileFilter.filter(originFiles);
                System.out.println("change event!");
                switch (event.eventType()) {
                    case CREATE: {
                        watchItem.getCreateHandler().handle(files);
                        break;
                    }
                    case MODIFY: {
                        watchItem.getUpdateHandler().handle(files);
                        break;
                    }
                    case DELETE: {
                        watchItem.getDeleteHandler().handle(files);
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex.getLocalizedMessage());
            }
        };
        DirectoryWatcher watcher = DirectoryWatcher.builder().path(watchItem.path).listener(listener).build();
        watcher.watchAsync();
        this.dirWatcherMap.put(uri, Pair.of(watchItem, watcher));
    }

    public static class FileWatchItem {
        private Path path;
        private DirSingleFileFilter fileFilter;
        private FileHandler createHandler;
        private FileHandler updateHandler;
        private FileHandler deleteHandler;

        public Path getPath() {
            return this.path;
        }

        public DirSingleFileFilter getFileFilter() {
            return this.fileFilter;
        }

        public FileHandler getCreateHandler() {
            return this.createHandler;
        }

        public FileHandler getUpdateHandler() {
            return this.updateHandler;
        }

        public FileHandler getDeleteHandler() {
            return this.deleteHandler;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public void setFileFilter(DirSingleFileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        public void setCreateHandler(FileHandler createHandler) {
            this.createHandler = createHandler;
        }

        public void setUpdateHandler(FileHandler updateHandler) {
            this.updateHandler = updateHandler;
        }

        public void setDeleteHandler(FileHandler deleteHandler) {
            this.deleteHandler = deleteHandler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileWatchItem)) {
                return false;
            }
            FileWatchItem other = (FileWatchItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                return false;
            }
            DirSingleFileFilter this$fileFilter = this.getFileFilter();
            DirSingleFileFilter other$fileFilter = other.getFileFilter();
            if (this$fileFilter == null ? other$fileFilter != null : !this$fileFilter.equals(other$fileFilter)) {
                return false;
            }
            FileHandler this$createHandler = this.getCreateHandler();
            FileHandler other$createHandler = other.getCreateHandler();
            if (this$createHandler == null ? other$createHandler != null : !this$createHandler.equals(other$createHandler)) {
                return false;
            }
            FileHandler this$updateHandler = this.getUpdateHandler();
            FileHandler other$updateHandler = other.getUpdateHandler();
            if (this$updateHandler == null ? other$updateHandler != null : !this$updateHandler.equals(other$updateHandler)) {
                return false;
            }
            FileHandler this$deleteHandler = this.getDeleteHandler();
            FileHandler other$deleteHandler = other.getDeleteHandler();
            return !(this$deleteHandler == null ? other$deleteHandler != null : !this$deleteHandler.equals(other$deleteHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileWatchItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            DirSingleFileFilter $fileFilter = this.getFileFilter();
            result = result * 59 + ($fileFilter == null ? 43 : $fileFilter.hashCode());
            FileHandler $createHandler = this.getCreateHandler();
            result = result * 59 + ($createHandler == null ? 43 : $createHandler.hashCode());
            FileHandler $updateHandler = this.getUpdateHandler();
            result = result * 59 + ($updateHandler == null ? 43 : $updateHandler.hashCode());
            FileHandler $deleteHandler = this.getDeleteHandler();
            result = result * 59 + ($deleteHandler == null ? 43 : $deleteHandler.hashCode());
            return result;
        }

        public String toString() {
            return "DirWatcher.FileWatchItem(path=" + this.getPath() + ", fileFilter=" + this.getFileFilter() + ", createHandler=" + this.getCreateHandler() + ", updateHandler=" + this.getUpdateHandler() + ", deleteHandler=" + this.getDeleteHandler() + ")";
        }

        public FileWatchItem(Path path, DirSingleFileFilter fileFilter, FileHandler createHandler, FileHandler updateHandler, FileHandler deleteHandler) {
            this.path = path;
            this.fileFilter = fileFilter;
            this.createHandler = createHandler;
            this.updateHandler = updateHandler;
            this.deleteHandler = deleteHandler;
        }
    }

    public static class DirWatchItem {
        private Path path;
        private DirFileFilter fileFilter;
        private DirHandler createHandler;
        private DirHandler updateHandler;
        private DirHandler deleteHandler;

        public Path getPath() {
            return this.path;
        }

        public DirFileFilter getFileFilter() {
            return this.fileFilter;
        }

        public DirHandler getCreateHandler() {
            return this.createHandler;
        }

        public DirHandler getUpdateHandler() {
            return this.updateHandler;
        }

        public DirHandler getDeleteHandler() {
            return this.deleteHandler;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public void setFileFilter(DirFileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        public void setCreateHandler(DirHandler createHandler) {
            this.createHandler = createHandler;
        }

        public void setUpdateHandler(DirHandler updateHandler) {
            this.updateHandler = updateHandler;
        }

        public void setDeleteHandler(DirHandler deleteHandler) {
            this.deleteHandler = deleteHandler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirWatchItem)) {
                return false;
            }
            DirWatchItem other = (DirWatchItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                return false;
            }
            DirFileFilter this$fileFilter = this.getFileFilter();
            DirFileFilter other$fileFilter = other.getFileFilter();
            if (this$fileFilter == null ? other$fileFilter != null : !this$fileFilter.equals(other$fileFilter)) {
                return false;
            }
            DirHandler this$createHandler = this.getCreateHandler();
            DirHandler other$createHandler = other.getCreateHandler();
            if (this$createHandler == null ? other$createHandler != null : !this$createHandler.equals(other$createHandler)) {
                return false;
            }
            DirHandler this$updateHandler = this.getUpdateHandler();
            DirHandler other$updateHandler = other.getUpdateHandler();
            if (this$updateHandler == null ? other$updateHandler != null : !this$updateHandler.equals(other$updateHandler)) {
                return false;
            }
            DirHandler this$deleteHandler = this.getDeleteHandler();
            DirHandler other$deleteHandler = other.getDeleteHandler();
            return !(this$deleteHandler == null ? other$deleteHandler != null : !this$deleteHandler.equals(other$deleteHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DirWatchItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            DirFileFilter $fileFilter = this.getFileFilter();
            result = result * 59 + ($fileFilter == null ? 43 : $fileFilter.hashCode());
            DirHandler $createHandler = this.getCreateHandler();
            result = result * 59 + ($createHandler == null ? 43 : $createHandler.hashCode());
            DirHandler $updateHandler = this.getUpdateHandler();
            result = result * 59 + ($updateHandler == null ? 43 : $updateHandler.hashCode());
            DirHandler $deleteHandler = this.getDeleteHandler();
            result = result * 59 + ($deleteHandler == null ? 43 : $deleteHandler.hashCode());
            return result;
        }

        public String toString() {
            return "DirWatcher.DirWatchItem(path=" + this.getPath() + ", fileFilter=" + this.getFileFilter() + ", createHandler=" + this.getCreateHandler() + ", updateHandler=" + this.getUpdateHandler() + ", deleteHandler=" + this.getDeleteHandler() + ")";
        }

        public DirWatchItem(Path path, DirFileFilter fileFilter, DirHandler createHandler, DirHandler updateHandler, DirHandler deleteHandler) {
            this.path = path;
            this.fileFilter = fileFilter;
            this.createHandler = createHandler;
            this.updateHandler = updateHandler;
            this.deleteHandler = deleteHandler;
        }
    }
}

