/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.log.log4j2;

import net.sf.log4jdbc.Properties;
import net.sf.log4jdbc.log.AbstractSpyLogDelegator;
import net.sf.log4jdbc.log.log4j2.message.ConnectionMessage;
import net.sf.log4jdbc.log.log4j2.message.ExceptionOccuredMessage;
import net.sf.log4jdbc.log.log4j2.message.MethodReturnedMessage;
import net.sf.log4jdbc.log.log4j2.message.SqlTimingOccurredMessage;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollector;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollectorPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;

public class Log4j2SpyLogDelegator
extends AbstractSpyLogDelegator {
    private static final Logger LOGGER = LogManager.getLogger((String)"log4jdbc.log4j2");
    private static final Logger DEBUGLOGGER = LogManager.getLogger((String)"log4jdbc.debug");
    private static final Marker SQL_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_SQL");
    private static final Marker SELECT_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_SELECT", (Marker)SQL_MARKER);
    private static final Marker INSERT_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_INSERT", (Marker)SQL_MARKER);
    private static final Marker UPDATE_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_UPDATE", (Marker)SQL_MARKER);
    private static final Marker DELETE_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_DELETE", (Marker)SQL_MARKER);
    private static final Marker CREATE_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_CREATE", (Marker)SQL_MARKER);
    private static final Marker NON_STATEMENT_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_NON_STATEMENT");
    private static final Marker CONNECTION_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_CONNECTION", (Marker)NON_STATEMENT_MARKER);
    private static final Marker OTHER_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_OTHER", (Marker)NON_STATEMENT_MARKER);
    private static final Marker JDBC_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_JDBC", (Marker)OTHER_MARKER);
    private static final Marker AUDIT_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_AUDIT", (Marker)JDBC_MARKER);
    private static final Marker RESULTSET_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_RESULTSET", (Marker)JDBC_MARKER);
    private static final Marker RESULTSETTABLE_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_RESULTSETTABLE", (Marker)OTHER_MARKER);
    private static final Marker EXCEPTION_MARKER = MarkerManager.getMarker((String)"LOG4JDBC_EXCEPTION");

    @Override
    public boolean isJdbcLoggingEnabled() {
        return LOGGER.isErrorEnabled();
    }

    @Override
    public void filteredExceptionOccured(Spy spy, String methodCall, Exception e, String sql, long execTime) {
        LOGGER.error(EXCEPTION_MARKER, (Message)new ExceptionOccuredMessage(spy, methodCall, sql, execTime, LOGGER.isDebugEnabled(EXCEPTION_MARKER)), (Throwable)e);
    }

    @Override
    public void methodReturned(Spy spy, String methodCall, String returnMsg) {
        String classType = spy.getClassType();
        Marker marker = "ResultSet".equals(classType) ? RESULTSET_MARKER : AUDIT_MARKER;
        LOGGER.info(marker, (Message)new MethodReturnedMessage(spy, methodCall, returnMsg, LOGGER.isDebugEnabled(marker)));
    }

    @Override
    public void constructorReturned(Spy spy, String constructionInfo) {
    }

    @Override
    public void sqlOccurred(Spy spy, String methodCall, String sql) {
    }

    @Override
    public void sqlTimingOccurred(Spy spy, long execTime, String methodCall, String sql) {
        String operation = this.getSqlOperation(sql);
        if (Properties.isDumpSqlFilteringOn() && !this.shouldSqlBeLogged(operation)) {
            return;
        }
        Marker marker = this.getStatementMarker(operation);
        SqlTimingOccurredMessage message = new SqlTimingOccurredMessage(spy, execTime, methodCall, sql, LOGGER.isDebugEnabled(marker));
        if (Properties.isSqlTimingErrorThresholdEnabled() && execTime >= Properties.getSqlTimingErrorThresholdMsec()) {
            LOGGER.error(marker, (Message)message);
        } else if (LOGGER.isWarnEnabled()) {
            if (Properties.isSqlTimingWarnThresholdEnabled() && execTime >= Properties.getSqlTimingWarnThresholdMsec()) {
                LOGGER.warn(marker, (Message)message);
            } else {
                LOGGER.info(marker, (Message)message);
            }
        }
    }

    private String getSqlOperation(String sql) {
        if (sql == null) {
            return "";
        }
        if ((sql = sql.trim()).length() < 6) {
            return "";
        }
        return sql.substring(0, 6).toLowerCase();
    }

    private Marker getStatementMarker(String operation) {
        if (operation == null) {
            return SQL_MARKER;
        }
        if ("select".equals(operation)) {
            return SELECT_MARKER;
        }
        if ("insert".equals(operation)) {
            return INSERT_MARKER;
        }
        if ("update".equals(operation)) {
            return UPDATE_MARKER;
        }
        if ("delete".equals(operation)) {
            return DELETE_MARKER;
        }
        if ("create".equals(operation)) {
            return CREATE_MARKER;
        }
        return SQL_MARKER;
    }

    private boolean shouldSqlBeLogged(String operation) {
        return operation == null || Properties.isDumpSqlSelect() && "select".equals(operation) || Properties.isDumpSqlInsert() && "insert".equals(operation) || Properties.isDumpSqlUpdate() && "update".equals(operation) || Properties.isDumpSqlDelete() && "delete".equals(operation) || Properties.isDumpSqlCreate() && "create".equals(operation);
    }

    @Override
    public void connectionOpened(Spy spy, long execTime) {
        this.connectionModified(spy, execTime, ConnectionMessage.Operation.OPENING);
    }

    @Override
    public void connectionClosed(Spy spy, long execTime) {
        this.connectionModified(spy, execTime, ConnectionMessage.Operation.CLOSING);
    }

    @Override
    public void connectionAborted(Spy spy, long execTime) {
        this.connectionModified(spy, execTime, ConnectionMessage.Operation.ABORTING);
    }

    private void connectionModified(Spy spy, long execTime, ConnectionMessage.Operation operation) {
        LOGGER.info(CONNECTION_MARKER, (Message)new ConnectionMessage(spy, execTime, operation, LOGGER.isDebugEnabled(CONNECTION_MARKER)));
    }

    @Override
    public void debug(String msg) {
        DEBUGLOGGER.debug(msg);
    }

    @Override
    public boolean isResultSetCollectionEnabled() {
        return LOGGER.isInfoEnabled(RESULTSETTABLE_MARKER);
    }

    @Override
    public boolean isResultSetCollectionEnabledWithUnreadValueFillIn() {
        return LOGGER.isDebugEnabled(RESULTSETTABLE_MARKER);
    }

    @Override
    public void resultSetCollected(ResultSetCollector resultSetCollector) {
        String resultToPrint = new ResultSetCollectorPrinter().getResultSetToPrint(resultSetCollector);
        LOGGER.info(RESULTSETTABLE_MARKER, resultToPrint);
    }
}

