/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.log.log4j2.message;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.log4jdbc.Properties;

public abstract class SqlMessage {
    protected static String nl = System.getProperty("line.separator");
    private boolean isDebugEnabled;
    private String message;

    public SqlMessage() {
        this(false);
    }

    public SqlMessage(boolean isDebugEnabled) {
        this.setDebugEnabled(isDebugEnabled);
        this.setMessage(null);
    }

    protected abstract void buildMessage();

    public String getFormattedMessage() {
        if (this.getMessage() == null) {
            this.buildMessage();
        }
        return this.getMessage();
    }

    public String getFormat() {
        return this.getFormattedMessage();
    }

    public Object[] getParameters() {
        return null;
    }

    public Throwable getThrowable() {
        return null;
    }

    protected String processSql(String sql) {
        if (sql == null) {
            return null;
        }
        if (Properties.isSqlTrim()) {
            sql = sql.trim();
        }
        StringBuilder output = new StringBuilder();
        if (Properties.getDumpSqlMaxLineLength() <= 0) {
            output.append(sql);
        } else {
            StringTokenizer st = new StringTokenizer(sql);
            int linelength = 0;
            while (st.hasMoreElements()) {
                String token = (String)st.nextElement();
                output.append(token);
                linelength += token.length();
                output.append(" ");
                if (++linelength <= Properties.getDumpSqlMaxLineLength()) continue;
                output.append(nl);
                linelength = 0;
            }
        }
        if (Properties.isDumpSqlAddSemicolon()) {
            output.append(";");
        }
        String stringOutput = output.toString();
        if (Properties.isTrimExtraBlankLinesInSql()) {
            LineNumberReader lineReader = new LineNumberReader(new StringReader(stringOutput));
            output = new StringBuilder();
            int contiguousBlankLines = 0;
            int lineCount = 0;
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    if (lineCount > 0) {
                        output.append(nl);
                    }
                    if (line.trim().length() == 0) {
                        if (++contiguousBlankLines > 1) {
                            continue;
                        }
                    } else {
                        contiguousBlankLines = 0;
                        output.append(line);
                    }
                    ++lineCount;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringOutput = output.toString();
        }
        return stringOutput;
    }

    protected static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            StringBuffer dump = new StringBuffer();
            if (Properties.isDumpFullDebugStackTrace()) {
                boolean first = true;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) continue;
                    if (first) {
                        first = false;
                    } else {
                        dump.append("  ");
                    }
                    dump.append("at ");
                    dump.append(stackTrace[i]);
                    dump.append(nl);
                }
            } else {
                int j;
                dump.append(" ");
                int firstLog4jdbcCall = 0;
                int lastApplicationCall = 0;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) {
                        firstLog4jdbcCall = i;
                        continue;
                    }
                    if (!Properties.isTraceFromApplication() || !Pattern.matches(Properties.getDebugStackPrefix(), className)) continue;
                    lastApplicationCall = i;
                    break;
                }
                if ((j = lastApplicationCall) == 0) {
                    j = stackTrace.length > 1 + firstLog4jdbcCall ? 1 + firstLog4jdbcCall : firstLog4jdbcCall;
                }
                dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            }
            return dump.toString();
        }
        return null;
    }

    protected boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    protected void setDebugEnabled(boolean isDebugEnabled) {
        this.isDebugEnabled = isDebugEnabled;
    }

    protected String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }
}

