/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.SpyLogFactory;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.ConnectionSpy;
import net.sf.log4jdbc.sql.jdbcapi.DriverSpy;
import net.sf.log4jdbc.sql.rdbmsspecifics.RdbmsSpecifics;

public class DataSourceSpy
implements DataSource,
Spy {
    private DataSource realDataSource;
    private SpyLogDelegator spyLogDelegator;
    private RdbmsSpecifics rdbmsSpecifics;

    public DataSourceSpy(DataSource realDataSource) {
        this(realDataSource, SpyLogFactory.getSpyLogDelegator());
    }

    public DataSourceSpy(DataSource realDataSource, SpyLogDelegator logDelegator) {
        this(realDataSource, logDelegator, null);
    }

    public DataSourceSpy(DataSource realDataSource, SpyLogDelegator logDelegator, RdbmsSpecifics rdbmsSpecifics) {
        if (realDataSource == null) {
            throw new IllegalStateException("realDataSource must not be null");
        }
        if (logDelegator == null) {
            throw new IllegalStateException("logDelegator must not be null");
        }
        this.realDataSource = realDataSource;
        this.spyLogDelegator = logDelegator;
        this.rdbmsSpecifics = rdbmsSpecifics;
    }

    @Deprecated
    public SpyLogDelegator getLogDelegator() {
        return this.getSpyLogDelegator();
    }

    @Deprecated
    public void setLogDelegator(SpyLogDelegator spyLogDelegator) {
        this.setSpyLogDelegator(spyLogDelegator);
    }

    public SpyLogDelegator getSpyLogDelegator() {
        return this.spyLogDelegator;
    }

    public void setSpyLogDelegator(SpyLogDelegator spyLogDelegator) {
        this.spyLogDelegator = spyLogDelegator;
    }

    protected void reportException(String methodCall, SQLException exception) {
        this.spyLogDelegator.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    private Object reportReturn(String methodCall, Object value) {
        this.spyLogDelegator.methodReturned(this, methodCall, "");
        return value;
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodCall = "getConnection()";
        long tstart = System.currentTimeMillis();
        try {
            Connection connection = this.realDataSource.getConnection();
            if (this.spyLogDelegator.isJdbcLoggingEnabled()) {
                return (Connection)this.reportReturn(methodCall, new ConnectionSpy(connection, this.getRdbmsSpecifics(connection), System.currentTimeMillis() - tstart, this.spyLogDelegator));
            }
            return connection;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String methodCall = "getConnection(" + username + ", password***)";
        long tstart = System.currentTimeMillis();
        try {
            Connection connection = this.realDataSource.getConnection(username, password);
            if (this.spyLogDelegator.isJdbcLoggingEnabled()) {
                return (Connection)this.reportReturn(methodCall, new ConnectionSpy(connection, this.getRdbmsSpecifics(connection), System.currentTimeMillis() - tstart, this.spyLogDelegator));
            }
            return connection;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        String methodCall = "getLoginTimeout()";
        try {
            return (Integer)this.reportReturn(methodCall, this.realDataSource.getLoginTimeout());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        String methodCall = "getLogWriter()";
        try {
            return (PrintWriter)this.reportReturn(methodCall, this.realDataSource.getLogWriter());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + iface + ")";
        try {
            return (Boolean)this.reportReturn(methodCall, this.realDataSource.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        String methodCall = "setLoginTimeout(" + seconds + ")";
        try {
            this.realDataSource.setLoginTimeout(seconds);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        String methodCall = "setLogWriter(" + out + ")";
        try {
            this.realDataSource.setLogWriter(out);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + iface + ")";
        try {
            return (T)this.reportReturn(methodCall, this.realDataSource.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        String methodCall = "getParentLogger()";
        try {
            return (Logger)this.reportReturn(methodCall, this.realDataSource.getParentLogger());
        }
        catch (SQLFeatureNotSupportedException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getClassType() {
        return "DataSource";
    }

    @Override
    public Integer getConnectionNumber() {
        return null;
    }

    private RdbmsSpecifics getRdbmsSpecifics(Connection connection) {
        return this.rdbmsSpecifics == null ? DriverSpy.getRdbmsSpecifics(connection) : this.rdbmsSpecifics;
    }
}

