/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.resultsetcollector;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.log4jdbc.sql.jdbcapi.ResultSetSpy;
import net.sf.log4jdbc.sql.resultsetcollector.JdbcUtils;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollector;

public class DefaultResultSetCollector
implements ResultSetCollector {
    private static final String NULL_RESULT_SET_VAL = "[null]";
    private static final String UNREAD = "[unread]";
    private static final String UNREAD_ERROR = "[unread!]";
    private boolean fillInUnreadValues = false;
    private boolean loaded;
    private int columnCount;
    private Map<Integer, String> columnLabels;
    private Map<Integer, String> columnNames;
    private boolean lastValueReturnedByNext;
    private List<Object> row;
    private List<List<Object>> rows;
    private Map<String, Integer> colNameToColIndex;
    private int colIndex;
    private static final List<String> GETTERS = Arrays.asList("getArray", "getAsciiStream", "getBigDecimal", "getBinaryStream", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getUnicodeStream", "getURL");

    public DefaultResultSetCollector(boolean fillInUnreadValues) {
        this.reset();
        this.fillInUnreadValues = fillInUnreadValues;
        this.lastValueReturnedByNext = true;
    }

    @Override
    public List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public void reset() {
        this.loaded = false;
        this.rows = null;
        this.row = null;
        this.colNameToColIndex = null;
        this.colIndex = -1;
        this.columnCount = 0;
        this.columnLabels = new HashMap<Integer, String>();
        this.columnNames = new HashMap<Integer, String>();
    }

    @Override
    public void loadMetaDataIfNeeded(ResultSet rs) {
        if (this.loaded) {
            return;
        }
        try {
            if (!rs.isClosed()) {
                this.loadMetaDataIfNeeded(rs.getMetaData());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    private void loadMetaDataIfNeeded(ResultSetMetaData metaData) {
        if (this.loaded) {
            return;
        }
        try {
            this.columnCount = metaData == null ? 0 : metaData.getColumnCount();
            this.colNameToColIndex = new HashMap<String, Integer>(this.columnCount);
            for (int column = 1; column <= this.columnCount; ++column) {
                String label = metaData.getColumnLabel(column).toLowerCase();
                String name = metaData.getColumnName(column).toLowerCase();
                this.columnLabels.put(column, label);
                this.columnNames.put(column, name);
                this.colNameToColIndex.put(label, column);
                this.colNameToColIndex.put(name, column);
                String table = metaData.getTableName(column).toLowerCase();
                this.colNameToColIndex.put(table + "." + name, column);
                this.colNameToColIndex.put(table + "." + label, column);
            }
            this.loaded = true;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public String getColumnLabel(int column) {
        return this.columnLabels.get(column);
    }

    @Override
    public boolean methodReturned(ResultSetSpy resultSetSpy, String methodCall, Object returnValue, Object targetObject, Object ... methodParams) {
        String methodName;
        if (methodCall.startsWith("get") && methodParams != null && methodParams.length == 1 && GETTERS.contains(methodName = methodCall.substring(0, methodCall.indexOf(40))) && this.getColumnCount() != 0) {
            this.setColIndexFromGetXXXMethodParams(methodParams);
            this.makeRowIfNeeded();
            this.row.set(this.colIndex - 1, returnValue);
        }
        if (methodCall.equals("wasNull()") && this.getColumnCount() != 0 && Boolean.TRUE.equals(returnValue)) {
            this.row.set(this.colIndex - 1, NULL_RESULT_SET_VAL);
        }
        if ("next()".equals(methodCall) || "first()".equals(methodCall)) {
            this.lastValueReturnedByNext = (Boolean)returnValue;
        }
        if ("next()".equals(methodCall) || "first()".equals(methodCall) || "close()".equals(methodCall)) {
            boolean isEndOfResultSet;
            this.loadMetaDataIfNeeded(resultSetSpy.getRealResultSet());
            boolean bl = isEndOfResultSet = "close()".equals(methodCall) && this.lastValueReturnedByNext || Boolean.FALSE.equals(returnValue);
            if (this.row != null) {
                if (this.rows == null) {
                    this.rows = new ArrayList<List<Object>>();
                }
                this.rows.add(this.row);
                this.row = null;
            }
            if (isEndOfResultSet) {
                return true;
            }
        }
        if ("getMetaData()".equals(methodCall)) {
            this.loadMetaDataIfNeeded((ResultSetMetaData)returnValue);
        }
        return false;
    }

    private void makeRowIfNeeded() {
        if (this.row == null) {
            this.row = new ArrayList<Object>(this.getColumnCount());
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.row.add(UNREAD);
            }
        }
    }

    private void setColIndexFromGetXXXMethodParams(Object ... methodParams) {
        Object param1 = methodParams[0];
        if (param1 == null) {
            throw new RuntimeException("ResultSet.getXXX() first param null? ");
        }
        if (param1 instanceof Integer) {
            this.colIndex = (Integer)param1;
        } else if (param1 instanceof String) {
            if (this.colNameToColIndex == null) {
                throw new RuntimeException("ResultSet.getXXX(colName): colNameToColIndex null");
            }
            Integer idx = this.colNameToColIndex.get(((String)param1).toLowerCase());
            if (idx == null) {
                throw new RuntimeException("ResultSet.getXXX(colName): could not look up name");
            }
            this.colIndex = idx;
        } else {
            throw new AssertionError((Object)("ResultSet.getXXX called with: " + param1.getClass().getName()));
        }
    }

    @Override
    public void preMethod(ResultSetSpy resultSetSpy, String methodCall, Object ... methodParams) {
        if ((methodCall.equals("next()") || methodCall.equals("close()")) && this.fillInUnreadValues && this.row != null) {
            int colIndex = 0;
            for (Object v : this.row) {
                if (v != null && v.toString().equals(UNREAD)) {
                    Object resultSetValue = null;
                    try {
                        resultSetValue = JdbcUtils.getResultSetValue(resultSetSpy.getRealResultSet(), colIndex + 1);
                    }
                    catch (SQLException e) {
                        resultSetValue = UNREAD_ERROR;
                    }
                    if (resultSetValue != null) {
                        this.row.set(colIndex, resultSetValue);
                    } else {
                        this.row.set(colIndex, NULL_RESULT_SET_VAL);
                    }
                }
                ++colIndex;
            }
        }
    }
}

