/*
 * Decompiled with CFR 0.152.
 */
package com.quick.qt.analytics.autotrack;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.Window;
import com.quick.qt.analytics.autotrack.FragmentTracker;
import com.quick.qt.analytics.autotrack.g;
import com.quick.qt.analytics.autotrack.i;
import com.quick.qt.analytics.autotrack.k;
import com.quick.qt.analytics.autotrack.l;
import com.quick.qt.analytics.autotrack.m;
import com.quick.qt.analytics.pro.c;
import com.quick.qt.analytics.pro.d;
import com.quick.qt.analytics.pro.f;
import com.quick.qt.commonsdk.R;
import com.quick.qt.commonsdk.debug.UMRTLog;
import com.quick.qt.commonsdk.framework.UMEnvelopeBuild;
import com.quick.qt.commonsdk.service.UMGlobalContext;
import com.quick.qt.commonsdk.statistics.UMServerURL;
import com.quick.qt.commonsdk.statistics.common.HelperUtils;
import com.quick.qt.commonsdk.statistics.idtracking.ImprintHandler;
import com.quick.qt.commonsdk.statistics.internal.UMImprintChangeCallback;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AutoTrackManager
implements l,
m {
    private static final String TAG = "QT.AutoTrackManager";
    public static final String VERSION = "1.6.3.PX";
    public static final String MIN_PLUGIN_VERSION = "0.0.1";
    static String ANDROID_PLUGIN_VERSION = "";
    public static final String CODELESS_SWITCH = "codelessStatus";
    public static final String ACTIVITY_SWITCH = "codelessCollectorPageStatus";
    public static final String FRAGMENT_SWITCH = "codelessCollectorFGPageStatus";
    public static final String CLICK_SWITCH = "codelessClickEventStatus";
    public static final String DEVICE_SWITCH = "currentDeviceEnable";
    public static final String COMPONENT_BLACK_LIST = "codelessIgnoreComponent";
    public static final String EVENT_REPORT_CONFIG = "eventSamplingRateVersion";
    public static final String DATA = "data";
    public static final String SAMPLING_RATE = "samplingRate";
    public static final String EVENT_IDS = "eventIds";
    private static final String CFG_CACHE_FILE = "qt_remote_cache.cfg";
    private static final String SP_LAST_CFG_REQUEST_PATH = "qt_last_cfg_path";
    private static Object samplingRateCfgLock = new Object();
    private static Map<String, Integer> samplingRateTable = new HashMap<String, Integer>();
    private static Object samplingRateTableLock = new Object();
    private static boolean firstLoadSamplingRateCfg = true;
    private static final Set<String> ingoreTypeTable = new HashSet<String>();
    private static Object ingoreTypeLock = new Object();
    private static boolean firstLoadIngoreTypeCfg = true;
    protected boolean mAutoTrack;
    protected m mFragmentAPI;
    protected List<Class> mIgnoredViewTypeList = new ArrayList<Class>();
    protected List<Integer> mAutoTrackIgnoredActivities = new ArrayList<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCfgFile(Context context) {
        String string = null;
        File file = new File(context.getFilesDir(), CFG_CACHE_FILE);
        if (file.exists()) {
            Object object = samplingRateCfgLock;
            synchronized (object) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = HelperUtils.readStreamToByteArray(fileInputStream);
                    HelperUtils.safeClose(fileInputStream);
                    fileInputStream = null;
                    string = new String(byArray, "UTF-8");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCfgFile(Context context, String string) {
        try {
            Object object = samplingRateCfgLock;
            synchronized (object) {
                File file = new File(context.getFilesDir(), CFG_CACHE_FILE);
                if (file.exists()) {
                    file.delete();
                }
                HelperUtils.writeFile(file, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertData2samplingRateTable(JSONArray jSONArray, Double d2) {
        if (null == jSONArray) {
            return;
        }
        String string = "";
        Object object = samplingRateTableLock;
        synchronized (object) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    string = jSONArray.getString(i2);
                }
                catch (JSONException jSONException) {
                    string = null;
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                Double d3 = d2 * 1000000.0;
                Integer n2 = d3.intValue();
                samplingRateTable.put(string, n2);
            }
        }
    }

    private static void writeLastRequestPath(Context context, String string) {
        try {
            SharedPreferences sharedPreferences = null;
            sharedPreferences = context.getApplicationContext().getSharedPreferences(SP_LAST_CFG_REQUEST_PATH, 0);
            sharedPreferences.edit().putString("last_request_path", string).commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void requestConfig(final Context context, final String string, final String string2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final Context context2 = context.getApplicationContext();
                String string3 = UMServerURL.DEFAULT_URL + string2;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Content-Type", "application/json");
                c c2 = new c(string3, c.a.b, hashMap, new d(){

                    @Override
                    public void a() {
                    }

                    @Override
                    public void a(String string) {
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            AutoTrackManager.writeCfgFile(context2, string);
                            AutoTrackManager.writeLastRequestPath(context2, string);
                        }
                        AutoTrackManager.loadSamplingRateCfg();
                    }

                    @Override
                    public void a(Throwable throwable) {
                        UMRTLog.i("QtTrackRT", "--->>> request : onRequestFailed: " + throwable.getMessage());
                    }
                });
                c2.a(3000, "");
            }
        };
        f.a(runnable);
    }

    private static String readLastRequestPath(Context context) {
        String string = "";
        try {
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(SP_LAST_CFG_REQUEST_PATH, 0);
            string = sharedPreferences.getString("last_request_path", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldReportEvent(String string, String string2) {
        Object object = samplingRateTableLock;
        synchronized (object) {
            UMRTLog.i("QtTrackRT", "--->>> pageName: " + string2);
            UMRTLog.i("QtTrackRT", "--->>> eventId: " + string);
            if (samplingRateTable.containsKey(string) || samplingRateTable.containsKey(string2)) {
                Integer n2 = "$$_page_end".equals(string) ? samplingRateTable.get(string2) : samplingRateTable.get(string);
                if (0 == n2) {
                    return false;
                }
                if (1000000 == n2) {
                    return true;
                }
                Random random = new Random();
                int n3 = random.nextInt(1000001);
                if (n3 <= n2) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needCheckSamplingRate() {
        Object object = samplingRateTableLock;
        synchronized (object) {
            UMRTLog.i("QtTrackRT", "--->>> samplingRateTable: " + samplingRateTable);
            return samplingRateTable.size() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSamplingRateCfg() {
        block22: {
            try {
                final Context context = UMGlobalContext.getAppContext();
                String string = AutoTrackManager.readCfgFile(context);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    Object object;
                    Object object2;
                    String string2;
                    Object object3;
                    JSONObject jSONObject = new JSONObject(string);
                    if (null != jSONObject && null != (object3 = jSONObject.optJSONArray(DATA))) {
                        string2 = null;
                        object2 = null;
                        object = 0.0;
                        if (object3.length() > 0) {
                            Object object4 = samplingRateTableLock;
                            synchronized (object4) {
                                samplingRateTable.clear();
                            }
                            for (int i2 = 0; i2 < object3.length(); ++i2) {
                                try {
                                    string2 = object3.getJSONObject(i2);
                                }
                                catch (JSONException jSONException) {
                                    string2 = null;
                                    continue;
                                }
                                if (null == string2) continue;
                                if (string2.has(EVENT_IDS)) {
                                    object2 = string2.optJSONArray(EVENT_IDS);
                                }
                                if (string2.has(SAMPLING_RATE)) {
                                    object = string2.optDouble(SAMPLING_RATE);
                                }
                                AutoTrackManager.insertData2samplingRateTable((JSONArray)object2, (Double)object);
                            }
                            if (firstLoadSamplingRateCfg) {
                                ImprintHandler.getImprintService(context).registImprintCallback(EVENT_REPORT_CONFIG, new UMImprintChangeCallback(){

                                    @Override
                                    public void onImprintValueChanged(String string, String string2) {
                                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                                            UMRTLog.i("QtTrackRT", "--->>> [\u4e91\u63a7]\u91c7\u6837\u7387\u914d\u7f6e\u53d8\u5316, \u91cd\u65b0\u8bf7\u6c42\u914d\u7f6e\u6570\u636e: " + string2);
                                            byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
                                            String string3 = new String(byArray);
                                            AutoTrackManager.requestConfig(context, string2, string3);
                                        }
                                    }
                                });
                            }
                            firstLoadSamplingRateCfg = false;
                        } else {
                            Object object5 = samplingRateTableLock;
                            synchronized (object5) {
                                samplingRateTable.clear();
                            }
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)(object3 = UMEnvelopeBuild.imprintProperty(context, EVENT_REPORT_CONFIG, ""))) && !(string2 = AutoTrackManager.readLastRequestPath(context)).equalsIgnoreCase((String)object3)) {
                        object2 = Base64.decode((byte[])((String)object3).getBytes(), (int)0);
                        object = new String((byte[])object2);
                        AutoTrackManager.requestConfig(context, (String)object3, (String)object);
                    }
                    break block22;
                }
                String string3 = UMEnvelopeBuild.imprintProperty(context, EVENT_REPORT_CONFIG, "");
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    byte[] byArray = Base64.decode((byte[])string3.getBytes(), (int)0);
                    String string4 = new String(byArray);
                    AutoTrackManager.requestConfig(context, string3, string4);
                } else {
                    if (firstLoadSamplingRateCfg) {
                        ImprintHandler.getImprintService(context).registImprintCallback(EVENT_REPORT_CONFIG, new UMImprintChangeCallback(){

                            @Override
                            public void onImprintValueChanged(String string, String string2) {
                                if (!TextUtils.isEmpty((CharSequence)string2)) {
                                    UMRTLog.i("QtTrackRT", "--->>> [\u4e91\u63a7]\u91c7\u6837\u7387\u914d\u7f6e\u53d8\u5316, \u91cd\u65b0\u8bf7\u6c42\u914d\u7f6e\u6570\u636e: " + string2);
                                    byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
                                    String string3 = new String(byArray);
                                    AutoTrackManager.requestConfig(context, string2, string3);
                                }
                            }
                        });
                    }
                    firstLoadSamplingRateCfg = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isComponetIgnored(String string) {
        boolean bl2 = false;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Object object = ingoreTypeLock;
            synchronized (object) {
                if (ingoreTypeTable.contains(string)) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadIngoreTypeTable() {
        block20: {
            try {
                Object object;
                String string;
                Context context = UMGlobalContext.getAppContext();
                String string2 = UMEnvelopeBuild.imprintProperty(context, CODELESS_SWITCH, "");
                if (!TextUtils.isEmpty((CharSequence)string2) && "0".equalsIgnoreCase(string = new String((byte[])(object = Base64.decode((byte[])string2.getBytes(), (int)0))))) {
                    Object object2 = ingoreTypeLock;
                    synchronized (object2) {
                        ingoreTypeTable.clear();
                        return;
                    }
                }
                object = UMEnvelopeBuild.imprintProperty(context, COMPONENT_BLACK_LIST, "");
                string = null;
                String string3 = "";
                String string4 = null;
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    byte[] byArray = Base64.decode((byte[])((String)object).getBytes(), (int)0);
                    string4 = new String(byArray);
                    UMRTLog.i("QtTrackRT", "--->>> [\u4e91\u63a7]\u63a7\u4ef6\u7c7b\u578b\u9ed1\u540d\u5355\uff1a" + string4);
                    try {
                        string = new JSONArray(string4);
                    }
                    catch (JSONException jSONException) {
                        string = null;
                    }
                    if (null == string) {
                        return;
                    }
                    if (string.length() > 0) {
                        Object object3 = ingoreTypeLock;
                        synchronized (object3) {
                            ingoreTypeTable.clear();
                            for (int i2 = 0; i2 < string.length(); ++i2) {
                                string3 = string.getString(i2);
                                ingoreTypeTable.add(string3);
                            }
                            if (firstLoadIngoreTypeCfg) {
                                ImprintHandler.getImprintService(context).registImprintCallback(COMPONENT_BLACK_LIST, new UMImprintChangeCallback(){

                                    @Override
                                    public void onImprintValueChanged(String string, String string2) {
                                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                                            UMRTLog.i("QtTrackRT", "--->>> [\u4e91\u63a7]\u63a7\u4ef6\u7c7b\u578b\u9ed1\u540d\u5355\u914d\u7f6e\u53d8\u5316, \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e: " + string2);
                                            AutoTrackManager.loadIngoreTypeTable();
                                        }
                                    }
                                });
                            }
                            firstLoadIngoreTypeCfg = false;
                            break block20;
                        }
                    }
                    Object object4 = ingoreTypeLock;
                    synchronized (object4) {
                        ingoreTypeTable.clear();
                    }
                    firstLoadIngoreTypeCfg = false;
                    break block20;
                }
                if (firstLoadIngoreTypeCfg) {
                    ImprintHandler.getImprintService(context).registImprintCallback(COMPONENT_BLACK_LIST, new UMImprintChangeCallback(){

                        @Override
                        public void onImprintValueChanged(String string, String string2) {
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                UMRTLog.i("QtTrackRT", "--->>> [\u4e91\u63a7]\u63a7\u4ef6\u7c7b\u578b\u9ed1\u540d\u5355\u914d\u7f6e\u53d8\u5316, \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e: " + string2);
                                AutoTrackManager.loadIngoreTypeTable();
                            }
                        }
                    });
                }
                firstLoadIngoreTypeCfg = false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private AutoTrackManager() {
        this.mFragmentAPI = new g();
        FragmentTracker.addFragmentCallbacks(new k());
        FragmentTracker.addFragmentCallbacks(new i());
        AutoTrackManager.loadIngoreTypeTable();
        AutoTrackManager.loadSamplingRateCfg();
    }

    public static AutoTrackManager getInstance() {
        return a.a;
    }

    public void setAutoEventEnabled(boolean bl2) {
        this.mAutoTrack = bl2;
    }

    @Override
    public void trackFragmentAppViewScreen() {
    }

    @Override
    public boolean isTrackFragmentAppViewScreenEnabled() {
        return this.mFragmentAPI.isTrackFragmentAppViewScreenEnabled();
    }

    @Override
    public void enableAutoTrackFragment(Class<?> clazz) {
        this.mFragmentAPI.enableAutoTrackFragment(clazz);
    }

    @Override
    public void enableAutoTrackFragments(List<Class<?>> list) {
        this.mFragmentAPI.enableAutoTrackFragments(list);
    }

    @Override
    public boolean isFragmentAutoTrackAppViewScreen(Class<?> clazz) {
        return this.mFragmentAPI.isFragmentAutoTrackAppViewScreen(clazz);
    }

    @Override
    public void ignoreAutoTrackFragments(List<Class<?>> list) {
        this.mFragmentAPI.ignoreAutoTrackFragments(list);
    }

    @Override
    public void ignoreAutoTrackFragment(Class<?> clazz) {
        this.mFragmentAPI.ignoreAutoTrackFragment(clazz);
    }

    @Override
    public void resumeIgnoredAutoTrackFragments(List<Class<?>> list) {
        this.mFragmentAPI.resumeIgnoredAutoTrackFragments(list);
    }

    @Override
    public void resumeIgnoredAutoTrackFragment(Class<?> clazz) {
        this.mFragmentAPI.resumeIgnoredAutoTrackFragment(clazz);
    }

    @Override
    public boolean isAutoTrackEnabled() {
        return this.mAutoTrack;
    }

    @Override
    public boolean isActivityAutoTrackAppClickIgnored(Class<?> clazz) {
        return false;
    }

    @Override
    public List<Class> getIgnoredViewTypeList() {
        if (this.mIgnoredViewTypeList == null) {
            this.mIgnoredViewTypeList = new ArrayList<Class>();
        }
        return this.mIgnoredViewTypeList;
    }

    @Override
    public void ignoreViewType(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (this.mIgnoredViewTypeList == null) {
            this.mIgnoredViewTypeList = new ArrayList<Class>();
        }
        if (!this.mIgnoredViewTypeList.contains(clazz)) {
            this.mIgnoredViewTypeList.add(clazz);
        }
    }

    @Override
    public void setViewID(View view, String string) {
        if (view != null && !TextUtils.isEmpty((CharSequence)string)) {
            view.setTag(R.id.qt_analytics_tag_view_id, (Object)string);
        }
    }

    @Override
    public void setViewID(Dialog dialog, String string) {
        try {
            if (dialog != null && !TextUtils.isEmpty((CharSequence)string) && dialog.getWindow() != null) {
                dialog.getWindow().getDecorView().setTag(R.id.qt_analytics_tag_view_id, (Object)string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setViewID(Object object, String string) {
        try {
            if (object == null) {
                return;
            }
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                clazz = Class.forName("android.support.v7.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz2 = Class.forName("androidx.appcompat.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<?> clazz3 = clazz != null ? clazz : clazz2;
            if (clazz3 == null) {
                return;
            }
            if (!clazz3.isInstance(object)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                Method method = object.getClass().getMethod("getWindow", new Class[0]);
                if (method == null) {
                    return;
                }
                Window window = (Window)method.invoke(object, new Object[0]);
                if (window != null) {
                    window.getDecorView().setTag(R.id.qt_analytics_tag_view_id, (Object)string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setViewEventID(View view, String string) {
        if (view != null && !TextUtils.isEmpty((CharSequence)string)) {
            view.setTag(R.id.qt_analytics_tag_view_ekv_id, (Object)string);
        }
    }

    @Override
    public void setViewEventID(Dialog dialog, String string) {
        try {
            if (dialog != null && !TextUtils.isEmpty((CharSequence)string) && dialog.getWindow() != null) {
                dialog.getWindow().getDecorView().setTag(R.id.qt_analytics_tag_view_ekv_id, (Object)string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setViewEventID(Object object, String string) {
        try {
            if (object == null) {
                return;
            }
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                clazz = Class.forName("android.support.v7.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz2 = Class.forName("androidx.appcompat.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<?> clazz3 = clazz != null ? clazz : clazz2;
            if (clazz3 == null) {
                return;
            }
            if (!clazz3.isInstance(object)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                Method method = object.getClass().getMethod("getWindow", new Class[0]);
                if (method == null) {
                    return;
                }
                Window window = (Window)method.invoke(object, new Object[0]);
                if (window != null) {
                    window.getDecorView().setTag(R.id.qt_analytics_tag_view_ekv_id, (Object)string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setViewProperties(View view, JSONObject jSONObject) {
        if (view == null || jSONObject == null) {
            return;
        }
        view.setTag(R.id.qt_analytics_tag_view_properties, (Object)jSONObject);
    }

    @Override
    public void ignoreAutoTrackActivities(List<Class<?>> list) {
    }

    @Override
    public void resumeAutoTrackActivities(List<Class<?>> list) {
    }

    @Override
    public void ignoreAutoTrackActivity(Class<?> clazz) {
    }

    @Override
    public void resumeAutoTrackActivity(Class<?> clazz) {
    }

    @Override
    public void ignoreView(View view) {
        if (view != null) {
            view.setTag(R.id.qt_analytics_tag_view_ignored, (Object)"1");
        }
    }

    @Override
    public void ignoreView(View view, boolean bl2) {
        if (view != null) {
            view.setTag(R.id.qt_analytics_tag_view_ignored, (Object)(bl2 ? "1" : "0"));
        }
    }

    @Override
    public void enableFragmentPageCollection(boolean bl2) {
        this.mFragmentAPI.enableFragmentPageCollection(bl2);
    }

    @Override
    public boolean isFragmentPageCollectionEnabled() {
        return this.mFragmentAPI.isFragmentPageCollectionEnabled();
    }

    private static class a {
        private static final AutoTrackManager a = new AutoTrackManager();

        private a() {
        }
    }
}

