/*
 * Decompiled with CFR 0.152.
 */
package com.quick.qt.analytics.process;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.quick.qt.analytics.AnalyticsConfig;
import com.quick.qt.analytics.c;
import com.quick.qt.analytics.pro.s;
import com.quick.qt.analytics.pro.v;
import com.quick.qt.analytics.process.DBFileTraversalUtil;
import com.quick.qt.analytics.process.UMProcessDBHelper;
import com.quick.qt.analytics.process.a;
import com.quick.qt.commonsdk.debug.UMRTLog;
import com.quick.qt.commonsdk.framework.UMEnvelopeBuild;
import com.quick.qt.commonsdk.framework.UMLogDataProtocol;
import com.quick.qt.commonsdk.statistics.common.HelperUtils;
import com.quick.qt.commonsdk.statistics.common.MLog;
import com.quick.qt.commonsdk.statistics.internal.PreferenceWrapper;
import com.quick.qt.commonsdk.statistics.noise.ABTest;
import com.quick.qt.commonsdk.utils.FileLockCallback;
import com.quick.qt.commonsdk.utils.FileLockUtil;
import com.quick.qt.commonsdk.utils.UMUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class UMProcessDBDatasSender
implements UMLogDataProtocol {
    public static final int UM_PROCESS_EVENT_KEY = 36945;
    public static final int UM_PROCESS_CONSTRUCTMESSAGE = 36946;
    private FileLockUtil mLockUtil = new FileLockUtil();
    private Context mContext;
    private s.d mPolicySelector;
    private static UMProcessDBDatasSender mInstance;
    private static ScheduledThreadPoolExecutor executor;
    private List<Integer> mGeneralBodyIds;

    private UMProcessDBDatasSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static UMProcessDBDatasSender getInstance(Context context) {
        if (mInstance == null) {
            Class<UMProcessDBDatasSender> clazz = UMProcessDBDatasSender.class;
            // MONITORENTER : com.quick.qt.analytics.process.UMProcessDBDatasSender.class
            if (mInstance == null) {
                mInstance = new UMProcessDBDatasSender();
            }
            // MONITOREXIT : clazz
        }
        UMProcessDBDatasSender.mInstance.mContext = context;
        return mInstance;
    }

    @Override
    public void workEvent(Object object, int n2) {
        if (!UMUtils.isMainProgress(this.mContext)) {
            return;
        }
        switch (n2) {
            case 36945: {
                executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        UMRTLog.i("QtTrackRT", "--->>> call processDBToMain start.");
                        UMProcessDBHelper.getInstance(UMProcessDBDatasSender.this.mContext).processDBToMain();
                    }
                }, 2L, TimeUnit.SECONDS);
                break;
            }
            case 36946: {
                UMRTLog.i("QtTrackRT", "--->>> recv UM_PROCESS_CONSTRUCTMESSAGE msg.");
                this.constructMessage();
                break;
            }
        }
    }

    @Override
    public void removeCacheData(Object object) {
        JSONObject jSONObject;
        if (object == null || this.mGeneralBodyIds == null || this.mGeneralBodyIds.size() == 0) {
            return;
        }
        JSONObject jSONObject2 = (JSONObject)object;
        if (jSONObject2.has("analytics") && (jSONObject = jSONObject2.optJSONObject("analytics")) != null && jSONObject.length() > 0 && jSONObject.has("ekv")) {
            UMProcessDBHelper.getInstance(this.mContext).deleteMainProcessEventDatasByIds(this.mGeneralBodyIds);
            this.mGeneralBodyIds.clear();
        }
    }

    @Override
    public JSONObject setupReportData(long l2) {
        int n2 = v.a().a(this.mContext);
        JSONObject jSONObject = this.generalBody();
        if (jSONObject.length() <= 0) {
            return null;
        }
        JSONObject jSONObject2 = this.generalHeader();
        JSONObject jSONObject3 = new JSONObject();
        try {
            JSONObject jSONObject4 = new JSONObject();
            if (n2 == 3) {
                jSONObject4.put("analytics", (Object)new JSONObject());
            } else if (jSONObject != null && jSONObject.length() > 0) {
                jSONObject4.put("analytics", (Object)jSONObject);
            }
            if (jSONObject2 != null && jSONObject2.length() > 0) {
                jSONObject3.put("header", (Object)jSONObject2);
            }
            if (jSONObject4.length() > 0) {
                if (jSONObject4.has("analytics")) {
                    JSONObject jSONObject5 = jSONObject4.optJSONObject("analytics");
                    if (jSONObject5.length() == 1) {
                        if (jSONObject5.optJSONObject("active_user") != null) {
                            return null;
                        }
                        if (!TextUtils.isEmpty((CharSequence)jSONObject5.optString("userlevel"))) {
                            return null;
                        }
                    }
                    if (jSONObject5.length() == 2 && jSONObject5.optJSONObject("active_user") != null && !TextUtils.isEmpty((CharSequence)jSONObject5.optString("userlevel"))) {
                        return null;
                    }
                }
                jSONObject3.put("content", (Object)jSONObject4);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jSONObject3;
    }

    private JSONObject generalHeader() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            if (AnalyticsConfig.mWrapperType != null && AnalyticsConfig.mWrapperVersion != null) {
                jSONObject.put("wrapper_version", (Object)AnalyticsConfig.mWrapperVersion);
                jSONObject.put("wrapper_type", (Object)AnalyticsConfig.mWrapperType);
            }
            int n2 = AnalyticsConfig.getVerticalType(this.mContext);
            jSONObject.put("vertical_type", n2);
            if (AnalyticsConfig.getVerticalType(this.mContext) == 1) {
                string = AnalyticsConfig.getGameSdkVersion(this.mContext);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = "1.6.3.PX";
                }
                jSONObject.put("sdk_version", (Object)string);
            } else {
                jSONObject.put("sdk_version", (Object)"1.6.3.PX");
            }
            string = null;
            String string2 = "";
            String string3 = "";
            if (this.mGeneralBodyIds.size() > 0 && (string = UMProcessDBHelper.getInstance(this.mContext).readVersionInfoFromColumId(this.mGeneralBodyIds.get(0))) != null) {
                string2 = string.optString("__av");
                string3 = string.optString("__vc");
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_version", (Object)UMUtils.getAppVersionName(this.mContext));
            } else {
                jSONObject.put("app_version", (Object)string2);
            }
            if (TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("version_code", (Object)UMUtils.getAppVersionCode(this.mContext));
            } else {
                jSONObject.put("version_code", (Object)string3);
            }
            String string4 = HelperUtils.MD5(AnalyticsConfig.getSecretKey(this.mContext));
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                jSONObject.put("secret", (Object)string4);
            }
            String string5 = UMEnvelopeBuild.imprintProperty(this.mContext, "pr_ve", null);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(this.mContext);
            jSONObject.put("$pr_ve", (Object)UMEnvelopeBuild.imprintProperty(this.mContext, "pr_ve", null));
            jSONObject.put("$ud_da", (Object)UMEnvelopeBuild.imprintProperty(this.mContext, "ud_da", null));
            jSONObject.put("pro_ver", (Object)"1.0.0");
            if (TextUtils.isEmpty((CharSequence)string5)) {
                jSONObject.put("$pr_ve", (Object)sharedPreferences.getString("vers_pre_version", "0"));
                String string6 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date(System.currentTimeMillis()));
                jSONObject.put("$ud_da", (Object)sharedPreferences.getString("vers_date", string6));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject generalBody() {
        JSONObject jSONObject = null;
        try {
            JSONObject jSONObject2;
            Object object;
            if (this.mGeneralBodyIds == null) {
                this.mGeneralBodyIds = new ArrayList<Integer>();
            }
            jSONObject = UMProcessDBHelper.getInstance(this.mContext).readMainEvents(UMEnvelopeBuild.maxDataSpace(this.mContext) - 2000L, this.mGeneralBodyIds);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(this.mContext);
            if (sharedPreferences != null && !TextUtils.isEmpty((CharSequence)(object = sharedPreferences.getString("userlevel", "")))) {
                jSONObject.put("userlevel", object);
            }
            if ((object = c.a(this.mContext)) != null && !TextUtils.isEmpty((CharSequence)object[0]) && !TextUtils.isEmpty((CharSequence)object[1])) {
                jSONObject2 = new JSONObject();
                jSONObject2.put("provider", (Object)object[0]);
                jSONObject2.put("puid", (Object)object[1]);
                if (jSONObject2.length() > 0) {
                    jSONObject.put("active_user", (Object)jSONObject2);
                }
            }
            if (ABTest.getService(this.mContext).isInTest()) {
                jSONObject2 = new JSONObject();
                jSONObject2.put(ABTest.getService(this.mContext).getTestName(), (Object)ABTest.getService(this.mContext).getGroupInfo());
                jSONObject.put("group_info", (Object)jSONObject2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jSONObject;
    }

    private void constructMessage() {
        int n2 = this.defconProcesserHandler();
        if (n2 != 0) {
            return;
        }
        this.mLockUtil.doFileOperateion(com.quick.qt.analytics.process.c.a(this.mContext, "", ""), (FileLockCallback)new ConstructMessageCallback());
    }

    private int defconProcesserHandler() {
        int n2 = v.a().a(this.mContext);
        if (n2 != 0) {
            try {
                DBFileTraversalUtil.traverseDBFiles(com.quick.qt.analytics.process.c.a(this.mContext), new ReplaceCallback(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UMProcessDBHelper.getInstance(this.mContext).deleteEventDatas("_main_", null, null);
        }
        return n2;
    }

    static {
        executor = new ScheduledThreadPoolExecutor(1);
    }

    private class ConstructMessageCallback
    implements FileLockCallback {
        private ConstructMessageCallback() {
        }

        @Override
        public boolean onFileLock(String string) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = UMProcessDBDatasSender.this.setupReportData(UMEnvelopeBuild.maxDataSpace(UMProcessDBDatasSender.this.mContext));
            if (jSONObject2 == null || jSONObject2.length() < 1) {
                return true;
            }
            JSONObject jSONObject3 = (JSONObject)jSONObject2.opt("header");
            JSONObject jSONObject4 = (JSONObject)jSONObject2.opt("content");
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("data", (Object)jSONObject4);
                MLog.d("\u5b50\u8fdb\u7a0b\u4e8b\u4ef6:" + jSONObject5.toString());
                UMRTLog.e("QtTrackRT", "\u5b50\u8fdb\u7a0b\u4e8b\u4ef6:" + jSONObject5.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (UMProcessDBDatasSender.this.mContext != null && jSONObject3 != null && jSONObject4 != null && (jSONObject = UMEnvelopeBuild.buildEnvelopeWithExtHeader(UMProcessDBDatasSender.this.mContext, jSONObject3, jSONObject4)) != null) {
                UMRTLog.e("QtTrackRT", "\u5b50\u8fdb\u7a0b\u4e8b\u4ef6 \u4fe1\u5c01\u6784\u5efa\u6210\u529f!");
                UMProcessDBDatasSender.this.removeCacheData(jSONObject);
            }
            return true;
        }

        @Override
        public boolean onFileLock(File file, int n2) {
            return false;
        }

        @Override
        public boolean onFileLock(String string, Object object) {
            return false;
        }
    }

    private class ReplaceCallback
    implements FileLockCallback {
        private ReplaceCallback() {
        }

        @Override
        public boolean onFileLock(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return true;
            }
            if (string.startsWith(com.quick.qt.analytics.process.a.c)) {
                string = string.replaceFirst(com.quick.qt.analytics.process.a.c, "");
            }
            string = string.replace(".db", "");
            UMProcessDBHelper.getInstance(UMProcessDBDatasSender.this.mContext).deleteEventDatas(string, null, null);
            return true;
        }

        @Override
        public boolean onFileLock(File file, int n2) {
            return false;
        }

        @Override
        public boolean onFileLock(String string, Object object) {
            return false;
        }
    }
}

