/*
 * Decompiled with CFR 0.152.
 */
package com.quick.qt.commonsdk.statistics.common;

import android.content.Context;
import com.quick.qt.commonsdk.framework.UMEnvelopeBuild;
import com.quick.qt.commonsdk.framework.UMModuleRegister;
import com.quick.qt.commonsdk.statistics.common.DeviceConfig;
import com.quick.qt.commonsdk.statistics.internal.StatTracer;
import com.quick.qt.commonsdk.statistics.noise.Defcon;

public class ReportPolicy {
    public static final int REALTIME = 0;
    public static final int BATCH_AT_LAUNCH = 1;
    static final int BATCH_AT_TERMINATE = 2;
    static final int IMMEDIATE = 3;
    public static final int DAILY = 4;
    public static final int WIFIONLY = 5;
    public static final int BATCH_BY_INTERVAL = 6;
    public static final int SMART_POLICY = 8;
    public static final int QUASI_REALTIME_POLICY = 11;

    public static boolean isValid(int n2) {
        boolean bl2 = false;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static class DebugPolicy
    extends ReportStrategy {
        private final long ReportInterval = 1000L;
        private StatTracer mTracer;

        public DebugPolicy(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= 1000L;
        }
    }

    public static class SmartPolicy
    extends ReportStrategy {
        private final long ReportInterval = 10800000L;
        private StatTracer mTracer;

        public SmartPolicy(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= 10800000L;
        }
    }

    public static class LatentPolicy
    extends ReportStrategy {
        private long latency;
        private long start = 0L;

        public LatentPolicy(int n2) {
            this.latency = n2;
            this.start = System.currentTimeMillis();
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return System.currentTimeMillis() - this.start >= this.latency;
        }

        @Override
        public boolean isValid() {
            return System.currentTimeMillis() - this.start < this.latency;
        }
    }

    public static class DefconPolicy
    extends ReportStrategy {
        private Defcon defcon;
        private StatTracer tracer;

        public DefconPolicy(StatTracer statTracer, Defcon defcon) {
            this.tracer = statTracer;
            this.defcon = defcon;
        }

        public boolean shouldSendMessageByInstant() {
            long l2 = System.currentTimeMillis();
            long l3 = this.defcon.getReqInterval();
            return l2 - UMEnvelopeBuild.getLastInstantBuildTime(UMModuleRegister.getAppContext()) >= l3;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            long l2 = System.currentTimeMillis();
            long l3 = this.defcon.getReqInterval();
            return l2 - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= l3;
        }

        @Override
        public boolean isValid() {
            return this.defcon.isOpen();
        }
    }

    public static class ReportWifiOnly
    extends ReportStrategy {
        private Context mContext = null;

        public ReportWifiOnly(Context context) {
            this.mContext = context;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return DeviceConfig.isWiFiAvailable(this.mContext);
        }
    }

    public static class ReportDaily
    extends ReportStrategy {
        private long HOURS_DAY = 86400000L;
        private StatTracer mTracer;

        public ReportDaily(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= this.HOURS_DAY;
        }
    }

    public static class ReportByInterval
    extends ReportStrategy {
        private static long MIN_REPORT_INTERVAL = 90000L;
        private static long MAX_REPORT_INTERVAL = 86400000L;
        private long mReportInterval;
        private StatTracer mTracer;

        public ReportByInterval(StatTracer statTracer, long l2) {
            this.mTracer = statTracer;
            this.setReportInterval(l2);
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            if (bl2) {
                return true;
            }
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= this.mReportInterval;
        }

        public void setReportInterval(long l2) {
            this.mReportInterval = l2 >= MIN_REPORT_INTERVAL && l2 <= MAX_REPORT_INTERVAL ? l2 : MIN_REPORT_INTERVAL;
        }

        public long getReportInterval() {
            return this.mReportInterval;
        }

        public static boolean isValidValue(int n2) {
            return (long)n2 >= MIN_REPORT_INTERVAL;
        }
    }

    public static class ReportAtLaunch
    extends ReportStrategy {
        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return bl2;
        }
    }

    public static class ReportRealtime
    extends ReportStrategy {
        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }
    }

    public static class ReportQuasiRealtime
    extends ReportStrategy {
        private static long DEFAULT_REPORT_INTERVAL = 3000L;
        private static long MIN_REPORT_INTERVAL = 1000L;
        private static long MAX_REPORT_INTERVAL = 90000L;
        private long mReportInterval;

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }

        public long getReportInterval() {
            return this.mReportInterval;
        }

        public void setReportInterval(long l2) {
            this.mReportInterval = l2 >= MIN_REPORT_INTERVAL && l2 <= MAX_REPORT_INTERVAL ? l2 : DEFAULT_REPORT_INTERVAL;
        }
    }

    public static class ReportStrategy {
        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }

        public boolean isValid() {
            return true;
        }
    }
}

