/*
 * Decompiled with CFR 0.152.
 */
package com.quick.qt.commonsdk.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.quick.qt.analytics.AnalyticsConfig;
import com.quick.qt.analytics.pro.ag;
import com.quick.qt.commonsdk.UMConfigure;
import com.quick.qt.commonsdk.config.FieldManager;
import com.quick.qt.commonsdk.debug.UMLog;
import com.quick.qt.commonsdk.framework.UMEnvelopeBuild;
import com.quick.qt.commonsdk.framework.UMFrUtils;
import com.quick.qt.commonsdk.internal.b;
import com.quick.qt.commonsdk.internal.c;
import com.quick.qt.commonsdk.internal.crash.UMCrashManager;
import com.quick.qt.commonsdk.statistics.AnalyticsConstants;
import com.quick.qt.commonsdk.statistics.UMServerURL;
import com.quick.qt.commonsdk.statistics.common.DeviceConfig;
import com.quick.qt.commonsdk.statistics.common.MLog;
import com.quick.qt.commonsdk.statistics.idtracking.i;
import com.quick.qt.commonsdk.utils.a;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public class UMUtils {
    private static final String TAG = "UMUtils";
    private static final String KEY_SHARED_PREFERENCES_NAME = ag.b().b("ucc");
    private static final String KEY_APP_KEY = "appkey";
    private static final String KEY_LAST_APP_KEY = "last_appkey";
    private static final String KEY_CHANNEL = "channel";
    public static final String UNKNOWN = "";
    public static final String MOBILE_NETWORK = "2G/3G";
    public static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String SD_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final Pattern pattern = Pattern.compile("UTDID\">([^<]+)");
    private static final String SP_FILE_NAME = ag.b().b("usi");
    private static final String KEY_SESSION_ID = "session_id";
    private static Object spLock = new Object();
    public static volatile String VALUE_ANALYTICS_VERSION = "";
    public static volatile String VALUE_GAME_VERSION = "";
    public static volatile String VALUE_PUSH_VERSION = "";
    public static volatile String VALUE_SHARE_VERSION = "";
    public static volatile String VALUE_APM_VERSION = "";
    public static volatile String VALUE_EFS_VERSION = "";
    public static volatile String VALUE_VERIFY_VERSION = "";
    public static volatile String VALUE_SMS_VERSION = "";
    public static volatile String VALUE_REC_VERSION_NAME = "";
    public static volatile String VALUE_VISUAL_VERSION = "";
    public static volatile String VALUE_ASMS_VERSION = "";
    public static volatile String VALUE_LINK_VERSION = "";
    public static volatile String VALUE_ABTEST_VERSION = "";
    private static volatile String sAppVersionName = "";
    private static volatile String sAppVersionCode = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMultiProcessSP(Context context, String string, String string2) {
        try {
            Object object = spLock;
            synchronized (object) {
                if (context == null || TextUtils.isEmpty((CharSequence)string) || string2 == null) {
                    return;
                }
                SharedPreferences sharedPreferences = null;
                if (UMUtils.isMainProgress(context)) {
                    sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
                } else {
                    String string3 = UMFrUtils.getSubProcessName(context);
                    sharedPreferences = context.getApplicationContext().getSharedPreferences(string3 + "_" + KEY_SHARED_PREFERENCES_NAME, 0);
                }
                if (sharedPreferences != null) {
                    sharedPreferences.edit().putString(string, string2).commit();
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMultiProcessSP(Context context, String string) {
        try {
            Object object = spLock;
            synchronized (object) {
                if (context == null || TextUtils.isEmpty((CharSequence)string)) {
                    return null;
                }
                SharedPreferences sharedPreferences = null;
                if (UMUtils.isMainProgress(context)) {
                    sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
                } else {
                    String string2 = UMFrUtils.getSubProcessName(context);
                    sharedPreferences = context.getApplicationContext().getSharedPreferences(string2 + "_" + KEY_SHARED_PREFERENCES_NAME, 0);
                }
                if (sharedPreferences != null) {
                    return sharedPreferences.getString(string, null);
                }
                return null;
            }
        }
        catch (Exception exception) {}
        finally {
            return null;
        }
    }

    public static void setLastAppkey(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            UMUtils.setMultiProcessSP(context, KEY_LAST_APP_KEY, string);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set last app key e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set last app key e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
        }
    }

    public static String getLastAppkey(Context context) {
        try {
            if (context == null) {
                return null;
            }
            return UMUtils.getMultiProcessSP(context, KEY_LAST_APP_KEY);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get last app key e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get last app key e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static void setAppkey(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            UMUtils.setMultiProcessSP(context, KEY_APP_KEY, string);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set app key e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set app key e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
        }
    }

    public static String getAppkey(Context context) {
        try {
            if (context == null) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)UMConfigure.sAppkey)) {
                return UMConfigure.sAppkey;
            }
            return UMUtils.getMultiProcessSP(context, KEY_APP_KEY);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app key e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app key e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static void setChannel(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            UMUtils.setMultiProcessSP(context, KEY_CHANNEL, string);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set channel e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set channel e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
        }
    }

    public static String getChannel(Context context) {
        try {
            if (context == null) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)UMConfigure.sChannel)) {
                return UMConfigure.sChannel;
            }
            return UMUtils.getMultiProcessSP(context, KEY_CHANNEL);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get channel e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get channel e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    private static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String parseId(String string) {
        if (string == null) {
            return null;
        }
        try {
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String readStreamToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        int n2 = 0;
        StringWriter stringWriter = new StringWriter();
        while (-1 != (n2 = inputStreamReader.read(cArray))) {
            stringWriter.write(cArray, 0, n2);
        }
        return stringWriter.toString();
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string = gL10.glGetString(7936);
            String string2 = gL10.glGetString(7937);
            stringArray[0] = string;
            stringArray[1] = string2;
            return stringArray;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("Could not read gpu infor, e is " + exception));
            }
            return new String[0];
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("Could not read gpu infor, e is " + throwable));
            }
            return new String[0];
        }
    }

    public static String getCPU() {
        try {
            String string;
            block12: {
                string = null;
                FileReader fileReader = null;
                BufferedReader bufferedReader = null;
                try {
                    fileReader = new FileReader("/proc/cpuinfo");
                    if (fileReader != null) {
                        try {
                            bufferedReader = new BufferedReader(fileReader, 1024);
                            string = bufferedReader.readLine();
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException iOException) {
                            if (AnalyticsConstants.UM_DEBUG) {
                                Log.e((String)TAG, (String)("Could not read from file /proc/cpuinfo, e is " + iOException));
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!AnalyticsConstants.UM_DEBUG) break block12;
                    Log.e((String)TAG, (String)("Could not read from file /proc/cpuinfo, e is " + fileNotFoundException));
                }
            }
            if (string != null) {
                int n2 = string.indexOf(58) + 1;
                string = string.substring(n2);
                return string.trim();
            }
            return UNKNOWN;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get cpu e is " + exception));
            }
            return UNKNOWN;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get cpu e is " + throwable));
            }
            return UNKNOWN;
        }
    }

    public static String getRegisteredOperator(Context context) {
        return DeviceConfig.getRegisteredOperator(context);
    }

    public static String getNetworkOperatorName(Context context) {
        return DeviceConfig.getNetworkOperatorName(context);
    }

    public static String getDisplayResolution(Context context) {
        if (context == null) {
            return UNKNOWN;
        }
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return UNKNOWN;
            }
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            String string = String.valueOf(n3) + "*" + String.valueOf(n2);
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get display resolution e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return UNKNOWN;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get display resolution e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return UNKNOWN;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOWN, UNKNOWN};
        if (context == null) {
            return stringArray;
        }
        try {
            if (!UMUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                stringArray[0] = UNKNOWN;
                return stringArray;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                stringArray[0] = UNKNOWN;
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network access mode e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network access mode e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
        }
        return stringArray;
    }

    public static boolean isSdCardWrittenable() {
        boolean bl2 = false;
        try {
            bl2 = Environment.getExternalStorageState().equals("mounted");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl2;
    }

    public static Locale getLocale(Context context) {
        if (context == null) {
            return null;
        }
        try {
            Locale locale;
            block10: {
                locale = null;
                try {
                    Configuration configuration = new Configuration();
                    configuration.setToDefaults();
                    Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
                    if (configuration != null) {
                        locale = configuration.locale;
                    }
                }
                catch (Exception exception) {
                    if (!AnalyticsConstants.UM_DEBUG) break block10;
                    Log.e((String)TAG, (String)("fail to read user config locale, e is " + exception));
                }
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return locale;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get locale e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get locale e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static String getMac(Context context) {
        if (context == null) {
            return null;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager == null) {
                return null;
            }
            if (UMUtils.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return wifiInfo.getMacAddress();
            }
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)"Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
            }
            return UNKNOWN;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get mac e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get mac e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static String getOperator(Context context) {
        String string = DeviceConfig.getRegisteredOperator(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "Unknown";
        }
        return string;
    }

    public static String getSubOSName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String string = null;
            Properties properties = UMUtils.getBuildProp();
            try {
                string = properties.getProperty(KEY_MIUI_VERSION_NAME);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    if (UMUtils.isFlyMe()) {
                        string = "Flyme";
                    } else if (!TextUtils.isEmpty((CharSequence)UMUtils.getYunOSVersion(properties))) {
                        string = "YunOS";
                    }
                } else {
                    string = "MIUI";
                }
            }
            catch (Exception exception) {
                string = null;
                UMCrashManager.reportCrash(context, exception);
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os name e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os name e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static String getSubOSVersion(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String string = null;
            Properties properties = UMUtils.getBuildProp();
            try {
                string = properties.getProperty(KEY_MIUI_VERSION_NAME);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    if (UMUtils.isFlyMe()) {
                        try {
                            string = UMUtils.getFlymeVersion(properties);
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            string = UMUtils.getYunOSVersion(properties);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                string = null;
                UMCrashManager.reportCrash(context, exception);
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os version e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os version e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    private static String getYunOSVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.yunos.version");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getFlymeVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.build.display.id").toLowerCase(Locale.getDefault());
            if (string.contains("flyme os")) {
                return string.split(" ")[2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Properties getBuildProp() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static boolean isFlyMe() {
        try {
            Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getDeviceType(Context context) {
        try {
            String string = "Phone";
            if (context == null) {
                return string;
            }
            boolean bl2 = (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
            string = bl2 ? "Tablet" : "Phone";
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get device type e is " + exception));
            }
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get device type e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
            return null;
        }
    }

    public static String getAppVersionCode(Context context) {
        if (context == null) {
            return UNKNOWN;
        }
        try {
            int n2 = AnalyticsConfig.getCustomAppVersionCode();
            if (n2 > 0) {
                return String.valueOf(n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = UNKNOWN;
        try {
            int n3 = 64;
            PackageInfo packageInfo = a.a().a(context, context.getPackageName(), n3);
            if (packageInfo != null) {
                int n4 = packageInfo.versionCode;
                sAppVersionCode = string = String.valueOf(n4);
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + exception));
            }
            return UNKNOWN;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + throwable));
            }
            return UNKNOWN;
        }
        return string;
    }

    public static String getAppVersinoCode(Context context, String string) {
        block6: {
            if (context == null || string == null) {
                return UNKNOWN;
            }
            try {
                int n2 = 64;
                PackageInfo packageInfo = a.a().a(context, string, n2);
                if (packageInfo != null) {
                    int n3 = packageInfo.versionCode;
                    return String.valueOf(n3);
                }
            }
            catch (Exception exception) {
                if (AnalyticsConstants.UM_DEBUG) {
                    Log.e((String)TAG, (String)("get app version code e is " + exception));
                }
            }
            catch (Throwable throwable) {
                if (!AnalyticsConstants.UM_DEBUG) break block6;
                Log.e((String)TAG, (String)("get app version code e is " + throwable));
            }
        }
        return UNKNOWN;
    }

    public static String getAppVersionName(Context context) {
        String string;
        if (context == null) {
            return UNKNOWN;
        }
        try {
            string = AnalyticsConfig.getCustomAppVersionName();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = UNKNOWN;
        try {
            int n2 = 64;
            PackageInfo packageInfo = a.a().a(context, context.getPackageName(), n2);
            if (packageInfo != null) {
                sAppVersionName = string = packageInfo.versionName;
            }
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + throwable));
            }
            string = UNKNOWN;
        }
        return string;
    }

    public static String getAppVersionName(Context context, String string) {
        if (context == null || string == null) {
            return UNKNOWN;
        }
        try {
            int n2 = 64;
            PackageInfo packageInfo = a.a().a(context, string, n2);
            if (packageInfo != null) {
                return packageInfo.versionName;
            }
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + throwable));
            }
            UMCrashManager.reportCrash(context, throwable);
        }
        return UNKNOWN;
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl2;
        block7: {
            bl2 = false;
            if (context == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int n2 = (Integer)method.invoke((Object)context, string);
                    if (n2 == 0) {
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                catch (Exception exception) {
                    UMCrashManager.reportCrash(context, exception);
                    bl2 = false;
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager.checkPermission(string, context.getPackageName()) == 0) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder.append(string.toUpperCase());
            if (i2 >= byArray.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static boolean isDebug(Context context) {
        if (context == null) {
            return false;
        }
        try {
            return (context.getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
            return false;
        }
    }

    public static String getAppName(Context context) {
        return DeviceConfig.getAppName(context);
    }

    public static String MD5(String string) {
        try {
            block10: {
                if (string != null) break block10;
                return null;
            }
            try {
                byte[] byArray = string.getBytes();
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    stringBuffer.append(String.format("%02X", byArray2[i2]));
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                try {
                    return string.replaceAll("[^[a-z][A-Z][0-9][.][_]]", UNKNOWN);
                }
                catch (Exception exception2) {
                    if (AnalyticsConstants.UM_DEBUG) {
                        Log.e((String)TAG, (String)("MD5 e is " + exception2));
                    }
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("MD5 e is " + throwable));
            }
            return null;
        }
    }

    public static String getFileMD5(File file) {
        try {
            MessageDigest messageDigest = null;
            FileInputStream fileInputStream = null;
            byte[] byArray = new byte[1024];
            try {
                int n2;
                if (!file.isFile()) {
                    return UNKNOWN;
                }
                messageDigest = MessageDigest.getInstance("MD5");
                fileInputStream = new FileInputStream(file);
                while ((n2 = fileInputStream.read(byArray, 0, 1024)) != -1) {
                    messageDigest.update(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                return null;
            }
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
            return String.format("%1$032x", bigInteger);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get file MD5 e is " + exception));
            }
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get file MD5 e is " + throwable));
            }
            return null;
        }
    }

    public static String encryptBySHA1(String string) {
        try {
            MessageDigest messageDigest = null;
            String string2 = null;
            byte[] byArray = string.getBytes();
            try {
                messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(byArray);
                string2 = UMUtils.bytes2Hex(messageDigest.digest());
            }
            catch (Exception exception) {
                return null;
            }
            return string2;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("encrypt by SHA1 e is " + exception));
            }
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("encrypt by SHA1 e is " + throwable));
            }
            return null;
        }
    }

    private static String bytes2Hex(byte[] byArray) {
        String string = UNKNOWN;
        String string2 = null;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            string2 = Integer.toHexString(byArray[i2] & 0xFF);
            if (string2.length() == 1) {
                string = string + "0";
            }
            string = string + string2;
        }
        return string;
    }

    public static String getUMId(Context context) {
        String string = null;
        try {
            if (context != null) {
                string = UMEnvelopeBuild.imprintProperty(context.getApplicationContext(), "umid", null);
            }
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
        }
        return string;
    }

    public static String getUmengToken(Context context) {
        String string = null;
        try {
            if (context != null) {
                string = UMEnvelopeBuild.imprintProperty(context.getApplicationContext(), "ztoken", null);
            }
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
        }
        return string;
    }

    public static String getAppkeyByXML(Context context) {
        String string = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                String string2 = applicationInfo.metaData.getString("UMENG_APPKEY");
                if (string2 != null) {
                    string = string2;
                    return string.trim();
                }
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i("QtTrackAgent", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getChannelByXML(Context context) {
        String string = null;
        try {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null && (object = applicationInfo.metaData.get("UMENG_CHANNEL")) != null) {
                String string2 = object.toString();
                if (string2 != null) {
                    string = string2;
                    return string.trim();
                }
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i("QtTrackAgent", "Could not read UMENG_CHANNEL meta-data from AndroidManifest.xml.");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static int getTargetSdkVersion(Context context) {
        int n2 = 0;
        try {
            n2 = context.getApplicationInfo().targetSdkVersion;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2;
    }

    public static boolean isMainProgress(Context context) {
        boolean bl2 = false;
        try {
            String string = UMFrUtils.getCurrentProcessName(context);
            String string2 = context.getApplicationContext().getPackageName();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && string.equals(string2)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public static String getOaidRequiredTime(Context context) {
        String string = null;
        if (FieldManager.allow("header_device_oaid")) {
            try {
                SharedPreferences sharedPreferences = context.getSharedPreferences(i.a, 0);
                if (sharedPreferences != null) {
                    string = sharedPreferences.getString("key_umeng_sp_oaid_required_time", UNKNOWN);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getZid(Context context) {
        String string = null;
        Context context2 = context.getApplicationContext();
        if (!UMConfigure.needSendZcfgEnv(context2)) {
            string = b.a(context2).a().a();
        }
        return string;
    }

    public static String getUUIDForZid(Context context) {
        String string = UNKNOWN;
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(SP_FILE_NAME, 0);
        if (sharedPreferences != null) {
            string = sharedPreferences.getString(KEY_SESSION_ID, UNKNOWN);
        }
        return string;
    }

    public static void setUUIDForZid(Context context) {
        String string = UNKNOWN;
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(SP_FILE_NAME, 0);
        UUID uUID = UUID.randomUUID();
        try {
            string = uUID.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sharedPreferences != null) {
            sharedPreferences.edit().putString(KEY_SESSION_ID, string).commit();
        }
    }

    public static String genId() {
        return "1234567890";
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            String string3 = (String)method.invoke(null, string, string2);
            return string3;
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    private static Class<?> getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        return clazz;
    }

    public static void saveSDKComponent() {
        StringBuffer stringBuffer;
        block23: {
            String string;
            Field field;
            Class<?> clazz;
            block22: {
                AnnotatedElement annotatedElement;
                Class<?> clazz2;
                stringBuffer = new StringBuffer();
                stringBuffer.append("a");
                if (UMConfigure.isDebugLog()) {
                    UMLog.mutlInfo(2, "\u7edf\u8ba1SDK\u7248\u672c\u53f7: 1.6.3.PX");
                }
                VALUE_ANALYTICS_VERSION = "1.6.3.PX";
                String string2 = c.b();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    VALUE_ASMS_VERSION = string2;
                    if (UMConfigure.isDebugLog()) {
                        UMLog.mutlInfo(2, "ZID SDK\u7248\u672c\u53f7: " + string2);
                    }
                }
                if ((clazz2 = UMUtils.getClass("com.umeng.vt.V")) != null) {
                    stringBuffer.append("v");
                    try {
                        annotatedElement = clazz2.getDeclaredField("VERSION");
                        clazz = (String)((Field)annotatedElement).get(clazz2);
                        if (!TextUtils.isEmpty((CharSequence)((Object)clazz))) {
                            VALUE_VISUAL_VERSION = clazz;
                            if (UMConfigure.isDebugLog()) {
                                UMLog.mutlInfo(2, "\u53ef\u89c6\u5316\u57cb\u70b9SDK\u7248\u672c\u53f7: " + clazz);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ((annotatedElement = UMUtils.getClass("com.umeng.umzid.ZIDManager")) != null) {
                    stringBuffer.append("z");
                }
                stringBuffer.append("i");
                try {
                    clazz = UMUtils.getClass("com.umeng.umcrash.UMCrash");
                    if (clazz == null) break block22;
                    stringBuffer.append("c");
                    try {
                        field = clazz.getDeclaredField("crashSdkVersion");
                        field.setAccessible(true);
                        string = (String)field.get(clazz);
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            VALUE_APM_VERSION = string;
                            if (UMConfigure.isDebugLog()) {
                                UMLog.mutlInfo(2, "APM SDK\u7248\u672c\u53f7: " + string);
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                clazz = UMUtils.getClass("com.umeng.umefs.UMEfs");
                if (clazz == null) break block23;
                stringBuffer.append("r");
                try {
                    field = clazz.getDeclaredField("efsSdkVersion");
                    field.setAccessible(true);
                    string = (String)field.get(clazz);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        VALUE_EFS_VERSION = string;
                        if (UMConfigure.isDebugLog()) {
                            UMLog.mutlInfo(2, "EFS SDK\u7248\u672c\u53f7: " + string);
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)stringBuffer)) {
            com.quick.qt.commonsdk.statistics.b.a = stringBuffer.toString();
            Log.i((String)"MobclickAgent", (String)("module init:" + com.quick.qt.commonsdk.statistics.b.a));
        }
    }

    public static void updateDeviceInfo2APM(String string) {
        Method method;
        Class<?> clazz;
        try {
            clazz = UMUtils.getClass("com.umeng.umcrash.UMCrash");
            if (clazz != null && (method = clazz.getDeclaredMethod("updateDeviceInfo", String.class)) != null) {
                method.invoke(null, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = UMUtils.getClass("com.umeng.umefs.UMEfs");
            if (clazz != null && (method = clazz.getDeclaredMethod("updateDeviceInfo", String.class)) != null) {
                method.invoke(null, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getApmFlag() {
        String string = UNKNOWN;
        try {
            Method method;
            Class<?> clazz = UMUtils.getClass("com.umeng.umcrash.UMCrash");
            if (clazz != null && (method = clazz.getDeclaredMethod("getUMAPMFlag", new Class[0])) != null) {
                method.setAccessible(true);
                string = (String)method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String[] getActiveUser(Context context) {
        return com.quick.qt.analytics.c.a(context);
    }

    public static boolean isAppInstalled(Context context, String string) {
        if (context == null) {
            return false;
        }
        boolean bl2 = false;
        try {
            int n2 = 0;
            PackageInfo packageInfo = a.a().a(context, string, n2);
            if (packageInfo != null) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl2;
    }

    private static byte[] getMiniArray() {
        byte[] byArray = new byte[]{1, 6, 8, 12, 13};
        return byArray;
    }

    public static byte[] genIv() {
        byte[] byArray;
        byte[] byArray2 = UMUtils.getMiniArray();
        byArray = new byte[]{10, 1, (byte)(byArray[0] + 1), 5, 4, (byte)(byArray[0] + byArray[3]), 7, 9, 23, 3, byArray2[0], byArray2[1], byArray2[2], byArray2[3], byArray2[4], (byte)(100 - byArray[7])};
        return byArray;
    }

    private static boolean isSupportType(Object object) {
        boolean bl2 = false;
        if (object != null && (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Short || object instanceof Double)) {
            bl2 = true;
        }
        return bl2;
    }

    public static void JSonObj2Map(JSONObject jSONObject, Map<String, Object> map) {
        if (jSONObject == null || map == null) {
            return;
        }
        Iterator iterator = jSONObject.keys();
        String string = UNKNOWN;
        Object object = null;
        while (iterator.hasNext()) {
            try {
                string = String.valueOf(iterator.next());
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                object = jSONObject.get(string);
                if (UMUtils.isSupportType(object)) {
                    map.put(string, object);
                    continue;
                }
                if (!(object instanceof Boolean)) continue;
                boolean bl2 = (Boolean)object;
                map.put(string, bl2 ? 1 : 0);
            }
            catch (Throwable throwable) {
                string = UNKNOWN;
                object = null;
            }
        }
    }

    public static void createFlagFile(Context context, String string) {
        File file = context.getFilesDir();
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean flagFileExist(Context context, String string) {
        File file = context.getFilesDir();
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        return file2.exists();
    }

    public static String getPuid(Context context) {
        String[] stringArray = com.quick.qt.analytics.c.a(context);
        if (stringArray != null && !TextUtils.isEmpty((CharSequence)stringArray[1])) {
            return stringArray[1];
        }
        return null;
    }

    public static String getTrackDomain() {
        String string = UNKNOWN;
        if (!TextUtils.isEmpty((CharSequence)UMServerURL.DEFAULT_URL)) {
            string = UMServerURL.DEFAULT_URL;
        } else {
            MLog.w("\u4e3b\u6536\u6570\u57df\u540d\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32\uff01");
        }
        if (TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)UMServerURL.SECONDARY_URL)) {
            string = UMServerURL.SECONDARY_URL;
        } else {
            MLog.w("\u5907\u7528\u6536\u6570\u57df\u540d\u53c2\u6570\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32\uff0cSDK\u5c06\u4e3b\u6536\u6570\u57df\u540d\u4f5c\u4e3a\u5907\u7528\u6536\u6570\u57df\u540d\u4f7f\u7528\u3002");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            MLog.e("SDK\u4e3b\u3001\u5907\u4e0a\u62a5\u57df\u540d\u90fd\u4e3anull");
        }
        return string;
    }
}

