/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.kronos;

import com.lyft.kronos.Clock;
import com.lyft.kronos.DefaultParam;
import com.lyft.kronos.KronosClock;
import com.lyft.kronos.SyncListener;
import com.lyft.kronos.SyncResponseCache;
import com.lyft.kronos.internal.KronosClockImpl;
import com.lyft.kronos.internal.ntp.DatagramFactoryImpl;
import com.lyft.kronos.internal.ntp.DnsResolverImpl;
import com.lyft.kronos.internal.ntp.SntpClient;
import com.lyft.kronos.internal.ntp.SntpResponseCacheImpl;
import com.lyft.kronos.internal.ntp.SntpServiceImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000fH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/lyft/kronos/ClockFactory;", "", "()V", "createKronosClock", "Lcom/lyft/kronos/KronosClock;", "localClock", "Lcom/lyft/kronos/Clock;", "syncResponseCache", "Lcom/lyft/kronos/SyncResponseCache;", "syncListener", "Lcom/lyft/kronos/SyncListener;", "ntpHosts", "", "", "requestTimeoutMs", "", "minWaitTimeBetweenSyncMs", "cacheExpirationMs", "kronos-java"})
public final class ClockFactory {
    public static final ClockFactory INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs, long cacheExpirationMs) {
        Intrinsics.checkNotNullParameter((Object)localClock, (String)"localClock");
        Intrinsics.checkNotNullParameter((Object)syncResponseCache, (String)"syncResponseCache");
        Intrinsics.checkNotNullParameter(ntpHosts, (String)"ntpHosts");
        if (localClock instanceof KronosClock) {
            throw (Throwable)new IllegalArgumentException("Local clock should implement Clock instead of KronosClock");
        }
        SntpClient sntpClient = new SntpClient(localClock, new DnsResolverImpl(), new DatagramFactoryImpl());
        SntpResponseCacheImpl cache = new SntpResponseCacheImpl(syncResponseCache, localClock);
        SntpServiceImpl ntpService = new SntpServiceImpl(sntpClient, localClock, cache, syncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, cacheExpirationMs);
        return new KronosClockImpl(ntpService, localClock);
    }

    public static /* synthetic */ KronosClock createKronosClock$default(Clock clock, SyncResponseCache syncResponseCache, SyncListener syncListener, List list, long l, long l2, long l3, int n, Object object) {
        if ((n & 4) != 0) {
            syncListener = null;
        }
        if ((n & 8) != 0) {
            list = DefaultParam.INSTANCE.getNTP_HOSTS();
        }
        if ((n & 0x10) != 0) {
            l = DefaultParam.INSTANCE.getTIMEOUT_MS();
        }
        if ((n & 0x20) != 0) {
            l2 = DefaultParam.INSTANCE.getMIN_WAIT_TIME_BETWEEN_SYNC_MS();
        }
        if ((n & 0x40) != 0) {
            l3 = DefaultParam.INSTANCE.getCACHE_EXPIRATION_MS();
        }
        return ClockFactory.createKronosClock(clock, syncResponseCache, syncListener, list, l, l2, l3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs) {
        return ClockFactory.createKronosClock$default(localClock, syncResponseCache, syncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, 0L, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs) {
        return ClockFactory.createKronosClock$default(localClock, syncResponseCache, syncListener, ntpHosts, requestTimeoutMs, 0L, 0L, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts) {
        return ClockFactory.createKronosClock$default(localClock, syncResponseCache, syncListener, ntpHosts, 0L, 0L, 0L, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache, @Nullable SyncListener syncListener) {
        return ClockFactory.createKronosClock$default(localClock, syncResponseCache, syncListener, null, 0L, 0L, 0L, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Clock localClock, @NotNull SyncResponseCache syncResponseCache) {
        return ClockFactory.createKronosClock$default(localClock, syncResponseCache, null, null, 0L, 0L, 0L, 124, null);
    }

    private ClockFactory() {
    }

    static {
        ClockFactory clockFactory;
        INSTANCE = clockFactory = new ClockFactory();
    }
}

