/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.Function;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.repository.AbstractFunctionRepository;
import com.lyncode.jtwig.functions.repository.DefaultFunctionRepository;
import com.lyncode.jtwig.functions.repository.FunctionDeclaration;
import com.lyncode.jtwig.tree.api.Calculable;

public class JtwigContext {
    private AbstractFunctionRepository functionRepository;
    private JtwigModelMap modelMap;

    public JtwigContext(JtwigModelMap modelMap, AbstractFunctionRepository functionRepository) {
        this.functionRepository = functionRepository;
        this.modelMap = modelMap;
    }

    public JtwigContext(JtwigModelMap modelMap) {
        this.functionRepository = new DefaultFunctionRepository(new FunctionDeclaration[0]);
        this.modelMap = modelMap;
    }

    public JtwigContext() {
        this.functionRepository = new DefaultFunctionRepository(new FunctionDeclaration[0]);
        this.modelMap = new JtwigModelMap();
    }

    public JtwigContext withModelAttribute(String key, Object value) {
        this.modelMap.add(key, value);
        return this;
    }

    public Function function(String name) throws FunctionNotFoundException {
        return this.functionRepository.retrieve(name);
    }

    public Object map(String key) {
        return this.modelMap.get(key);
    }

    public Object resolve(Object obj) throws CalculateException {
        if (obj instanceof Calculable) {
            return ((Calculable)obj).calculate(this);
        }
        return obj;
    }

    public void set(String key, Object value) {
        this.modelMap.add(key, value);
    }
}

