/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser;

import com.lyncode.jtwig.exception.EndClauseMissingException;
import com.lyncode.jtwig.exception.EndCodeMissingException;
import com.lyncode.jtwig.exception.ExpectingExpressionException;
import com.lyncode.jtwig.exception.ExtendMayOnlyBlocksException;
import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.exception.UnknownExpressionException;
import com.lyncode.jtwig.parser.JtwigKeyword;
import com.lyncode.jtwig.parser.JtwigSymbol;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Argumentable;
import com.lyncode.jtwig.tree.content.Content;
import com.lyncode.jtwig.tree.content.FastExpression;
import com.lyncode.jtwig.tree.content.ForExpression;
import com.lyncode.jtwig.tree.content.ForPairExpression;
import com.lyncode.jtwig.tree.content.IfExpression;
import com.lyncode.jtwig.tree.content.SetExpression;
import com.lyncode.jtwig.tree.content.Text;
import com.lyncode.jtwig.tree.documents.JtwigDocument;
import com.lyncode.jtwig.tree.documents.JtwigExtendsDocument;
import com.lyncode.jtwig.tree.documents.JtwigRootDocument;
import com.lyncode.jtwig.tree.helper.ElementList;
import com.lyncode.jtwig.tree.structural.BlockExpression;
import com.lyncode.jtwig.tree.structural.ExtendsExpression;
import com.lyncode.jtwig.tree.structural.IncludeExpression;
import com.lyncode.jtwig.tree.value.CharacterList;
import com.lyncode.jtwig.tree.value.Composition;
import com.lyncode.jtwig.tree.value.ElementMap;
import com.lyncode.jtwig.tree.value.FunctionElement;
import com.lyncode.jtwig.tree.value.IfTernaryOperator;
import com.lyncode.jtwig.tree.value.IntegerList;
import com.lyncode.jtwig.tree.value.MapSelection;
import com.lyncode.jtwig.tree.value.OperationBinary;
import com.lyncode.jtwig.tree.value.OperationUnary;
import com.lyncode.jtwig.tree.value.Operator;
import com.lyncode.jtwig.tree.value.Selection;
import com.lyncode.jtwig.tree.value.ValueList;
import com.lyncode.jtwig.tree.value.Variable;
import com.lyncode.jtwig.util.Simplifier;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.common.FileUtils;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class JtwigParser
extends BaseParser<Object> {
    public static JtwigDocument parse(JtwigResource input) throws ParseException {
        try {
            ReportingParseRunner runner = new ReportingParseRunner(((JtwigParser)Parboiled.createParser(JtwigParser.class, (Object[])new Object[0])).Start());
            ParsingResult result = runner.run(FileUtils.readAllText((InputStream)input.retrieve(), (Charset)Charset.defaultCharset()));
            return (JtwigDocument)result.resultValue;
        }
        catch (ParserRuntimeException e) {
            if (e.getCause() instanceof ParseBypassException) {
                ParseException innerException = ((ParseBypassException)e.getCause()).getInnerException();
                innerException.setExpression(e.getMessage());
                throw innerException;
            }
            throw new ParseException(e);
        }
        catch (ResourceException e) {
            throw new ParseException(e);
        }
    }

    protected boolean Debug() {
        System.out.println("Level: " + this.getContext().getLevel());
        if (!this.getContext().getValueStack().isEmpty()) {
            int i = 0;
            for (Object v : this.getContext().getValueStack()) {
                System.out.println("Position " + i++ + " of the stack " + v.getClass().getSimpleName() + " = '" + v.toString() + "'");
            }
        }
        System.out.println("Left to process: " + this.getContext().getMatch());
        return true;
    }

    protected Rule Start() {
        return this.FirstOf(this.ExtendingTemplate(), this.NormalTemplate(), new Object[0]);
    }

    protected Rule Ensure(ParseException e, Rule ... innerRule) {
        return this.FirstOf(this.Sequence(innerRule), this.throwException(e), new Object[0]);
    }

    protected boolean throwException(ParseException exception) throws ParseBypassException {
        throw new ParseBypassException(exception);
    }

    protected Rule Content() {
        return this.Sequence(this.push(new Content()), this.ZeroOrMore(this.FirstOf(this.AddToContent(this.FastExpression()), this.AddToContent(this.BlockExpression()), new Object[]{this.AddToContent(this.IncludeExpression()), this.AddToContent(this.ForExpression()), this.AddToContent(this.IfExpression()), this.AddToContent(this.SetExpression()), this.Sequence(this.OpenCode(), this.TestNot(this.FirstOf(this.SpecificKeyword(JtwigKeyword.ENDBLOCK), this.SpecificKeyword(JtwigKeyword.ENDFOR), new Object[]{this.SpecificKeyword(JtwigKeyword.ENDIF), this.SpecificKeyword(JtwigKeyword.IF), this.SpecificKeyword(JtwigKeyword.BLOCK), this.SpecificKeyword(JtwigKeyword.FOR), this.SpecificKeyword(JtwigKeyword.SET), this.SpecificKeyword(JtwigKeyword.ELSE), this.SpecificKeyword(JtwigKeyword.ELSEIF)})), new Object[]{this.throwException(new UnknownExpressionException())}), this.AddToContent(this.TextExpression())})), new Object[0]);
    }

    protected Rule AddToContent(Rule innerRule) {
        return this.Sequence(innerRule, ((Content)this.peek(1)).add(this.pop()), new Object[0]);
    }

    protected Rule NormalTemplate() {
        return this.Sequence(this.Spacing(), this.Content(), new Object[]{this.push(new JtwigRootDocument((Content)this.pop())), EOI});
    }

    protected Rule ExtendingTemplate() {
        return this.Sequence(this.Spacing(), this.ExtendsExpression(), new Object[]{this.push(new JtwigExtendsDocument((ExtendsExpression)this.pop())), this.ZeroOrMore(this.Spacing(), this.BlockExpression(), new Object[]{((JtwigExtendsDocument)this.peek(1)).add((BlockExpression)this.pop())}), this.Spacing(), this.Ensure(new ExtendMayOnlyBlocksException(), EOI)});
    }

    protected Rule BlockExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.BLOCK), new Object[]{this.Identifier(), this.Spacing(), this.push(new BlockExpression((String)this.pop())), this.CloseCode(), this.Content(), ((BlockExpression)this.peek(1)).setContent((Content)this.pop()), this.Ensure(new EndClauseMissingException(JtwigKeyword.BLOCK), this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ENDBLOCK), this.Spacing(), this.CloseCode())});
    }

    protected Rule ExtendsExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.EXTENDS), new Object[]{this.StringLiteral(), this.push(new ExtendsExpression((String)this.pop())), this.Spacing(), this.Ensure(new EndClauseMissingException(JtwigKeyword.EXTENDS), this.CloseCode())});
    }

    protected Rule IncludeExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.INCLUDE), new Object[]{this.StringLiteral(), this.push(new IncludeExpression((String)this.pop())), this.Spacing(), this.Ensure(new EndClauseMissingException(JtwigKeyword.INCLUDE), this.CloseCode())});
    }

    protected Rule TextExpression() {
        return this.Sequence(this.push(new Text()), this.OneOrMore(this.FirstOf(this.Sequence("{#", this.ZeroOrMore(this.TestNot("#}"), ANY, new Object[0]), new Object[]{"#}"}), this.Sequence(this.Escape(), ((Text)this.peek()).append(this.match()), new Object[0]), new Object[]{this.Sequence(this.TestNot(this.FirstOf(this.Symbol(JtwigSymbol.OPEN_FAST), this.Symbol(JtwigSymbol.OPEN_CODE), new Object[0])), ANY, new Object[]{((Text)this.peek()).append(this.match())})})).suppressSubnodes(), new Object[0]);
    }

    protected Rule IfExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.IF), new Object[]{this.Spacing(), this.Ensure(new ExpectingExpressionException(), this.Expression()), this.Spacing(), this.Ensure(new EndCodeMissingException(JtwigKeyword.IF), this.CloseCode()), this.push(new IfExpression(this.pop())), this.Content(), ((IfExpression)this.peek(1)).setContent((Content)this.pop()), this.ZeroOrMore(this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ELSEIF), new Object[]{this.Spacing(), this.Expression(), this.Spacing(), this.push(new IfExpression.ElseIfExpression(this.pop())), this.CloseCode(), this.Content(), ((IfExpression.ElseIfExpression)this.peek(1)).setContent((Content)this.pop()), ((IfExpression)this.peek(1)).addElseIf((IfExpression.ElseIfExpression)this.pop())})), this.Optional(this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ELSE), new Object[]{this.Spacing(), this.CloseCode(), this.Content(), ((IfExpression)this.peek(1)).setElseExpression(new IfExpression.ElseExpression((Content)this.pop()))})), this.Ensure(new EndClauseMissingException(JtwigKeyword.IF), this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ENDIF), this.Spacing(), this.CloseCode())});
    }

    protected Rule ForExpression() {
        return this.FirstOf(this.ForEachMapExpression(), this.ForEachExpression(), new Object[0]);
    }

    protected Rule ForEachExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.FOR), new Object[]{this.Variable(), this.Spacing(), this.SpecificKeyword(JtwigKeyword.IN), this.Expression(), this.Spacing(), this.push(new ForExpression((Variable)this.pop(1), this.pop())), this.Optional(this.ForFilters()), this.CloseCode(), this.Content(), ((ForExpression)this.peek(1)).setContent((Content)this.pop()), this.Ensure(new EndCodeMissingException(JtwigKeyword.FOR), this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ENDFOR), this.CloseCode())});
    }

    protected Rule ForEachMapExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.FOR), new Object[]{this.Variable(), this.Spacing(), this.FreeSymbol(JtwigSymbol.COMMA), this.Variable(), this.Spacing(), this.SpecificKeyword(JtwigKeyword.IN), this.Expression(), this.Spacing(), this.push(new ForPairExpression((Variable)this.pop(2), (Variable)this.pop(1), this.pop())), this.Optional(this.ForFilters()), this.CloseCode(), this.Content(), ((ForPairExpression)this.peek(1)).setContent((Content)this.pop()), this.Ensure(new EndCodeMissingException(JtwigKeyword.FOR), this.OpenCode(), this.SpecificKeyword(JtwigKeyword.ENDFOR), this.CloseCode())});
    }

    Rule ForFilters() {
        return this.ZeroOrMore(this.Sequence(this.FreeSymbol(JtwigSymbol.PIPE), this.SpecificKeyword(JtwigKeyword.FILTER), new Object[]{this.Expression(), ((ForExpression)this.peek(1)).add((FunctionElement)this.pop())}));
    }

    protected Rule SetExpression() {
        return this.Sequence(this.OpenCode(), this.SpecificKeyword(JtwigKeyword.SET), new Object[]{this.Variable(), this.Spacing(), this.push(new SetExpression((Variable)this.pop())), this.FreeSymbol(JtwigSymbol.ATTR), this.Expression(), this.Spacing(), ((SetExpression)this.peek(1)).setAssignment(this.pop()), this.Ensure(new EndClauseMissingException(JtwigKeyword.SET), this.CloseCode())});
    }

    protected Rule FastExpression() {
        return this.Sequence(this.Symbol(JtwigSymbol.OPEN_FAST), this.Spacing(), new Object[]{this.Expression(), this.Spacing(), this.push(new FastExpression(this.pop())), this.Ensure(new EndClauseMissingException(JtwigSymbol.OPEN_FAST), this.Symbol(JtwigSymbol.CLOSE_FAST))});
    }

    protected Rule Expression() {
        return this.Sequence(this.SpecificJtwigOperators(), this.push(Simplifier.simplify(this.pop())), new Object[0]);
    }

    protected Rule SpecificJtwigOperators() {
        return this.BinaryOperation(this.OrExpression(), Operator.STARTS_WITH, Operator.ENDS_WITH, Operator.MATCHES, Operator.IN);
    }

    protected Rule OrExpression() {
        return this.BinaryOperation(this.AndExpression(), Operator.OR);
    }

    Rule AndExpression() {
        return this.BinaryOperation(this.EqualityExpression(), Operator.AND);
    }

    Rule EqualityExpression() {
        return this.BinaryOperation(this.RelationalExpression(), Operator.EQUAL, Operator.DIFF);
    }

    protected Rule RelationalExpression() {
        return this.BinaryOperation(this.FirstOf(this.NotExpression(), this.Addition(), new Object[0]), Operator.LTE, Operator.GTE, Operator.LT, Operator.GT);
    }

    protected Rule NotExpression() {
        return this.UnaryOperation(this.Addition(), Operator.NOT);
    }

    protected Rule Addition() {
        return this.BinaryOperation(this.Multiplication(), Operator.ADD, Operator.SUB);
    }

    protected Rule Multiplication() {
        return this.BinaryOperation(this.ExtendedPrimary(), Operator.INT_DIV, Operator.INT_TIMES, Operator.TIMES, Operator.DIV, Operator.MOD);
    }

    protected Rule ExtendedPrimary() {
        return this.FirstOf(this.TernaryExpression(), this.Primary(), new Object[0]);
    }

    protected Rule TernaryExpression() {
        return this.Sequence(this.Primary(), this.push(new IfTernaryOperator(this.pop())), new Object[]{this.Spacing(), this.FreeSymbol(JtwigSymbol.QUESTION), this.Expression(), this.Spacing(), ((IfTernaryOperator)this.peek(1)).setIfTrueExpression(this.pop()), this.FreeSymbol(JtwigSymbol.DIV), this.Expression(), this.Spacing(), ((IfTernaryOperator)this.peek(1)).setIfFalseExpression(this.pop())});
    }

    protected Rule UnaryOperation(Rule innerRule, Operator ... operatorSymbols) {
        return this.Sequence(this.Save(this.FirstSymbolOf(false, operatorSymbols)), this.Spacing(), new Object[]{this.push(new OperationUnary()), ((OperationUnary)this.peek()).setOperator(Operator.fromString((String)this.pop(1))), innerRule, ((OperationUnary)this.peek(1)).setOperand(Simplifier.simplify(this.pop()))});
    }

    protected Rule BinaryOperation(Rule innerExpression, Operator ... operatorSymbols) {
        return this.Sequence(innerExpression, this.Spacing(), new Object[]{this.push(new OperationBinary(Simplifier.simplify(this.pop()))), this.ZeroOrMore(this.Sequence(this.Save(this.FirstSymbolOf(false, operatorSymbols)), this.Spacing(), new Object[]{innerExpression, ((OperationBinary)this.peek(2)).addOperator(Operator.fromString((String)this.pop(1))), ((OperationBinary)this.peek(1)).add(Simplifier.simplify(this.pop()))}))});
    }

    @SuppressNode
    protected Rule FirstSymbolOf(boolean spacing, Operator ... operators) {
        Object[] rules = new Rule[operators.length];
        int i = 0;
        for (Operator operator : operators) {
            rules[i++] = this.Terminal(operator.toString(), spacing);
        }
        return this.FirstOf(rules);
    }

    protected Rule Save(Rule rule) {
        return this.Sequence(rule, this.push(this.match()), new Object[0]);
    }

    protected Rule Primary() {
        return this.FirstOf(this.Selection(), this.Composition(), new Object[]{this.BasicExpression(), this.Sequence(this.FreeSymbol(JtwigSymbol.OPEN_PARENT), this.Expression(), new Object[]{this.Spacing(), this.Symbol(JtwigSymbol.CLOSE_PARENT)})});
    }

    protected Rule Composition() {
        return this.Sequence(this.BasicExpression(), this.push(new Composition(this.pop())), new Object[]{this.OneOrMore(this.Sequence(this.Spacing(), this.FreeSymbol(JtwigSymbol.PIPE), new Object[]{this.FirstOf(this.Function(), this.Variable(), new Object[0]), ((Composition)this.peek(1)).add(this.pop())}))});
    }

    protected Rule Selection() {
        return this.Sequence(this.BasicExpression(), this.push(new Selection(this.pop())), new Object[]{this.OneOrMore(this.Sequence(this.Spacing(), this.FreeSymbol(JtwigSymbol.DOT), new Object[]{this.DeclaredExpression(), ((Selection)this.peek(1)).add(this.pop())}))});
    }

    protected Rule BasicExpression() {
        return this.FirstOf(this.NativeExpression(), this.DeclaredExpression(), new Object[0]);
    }

    protected Rule NativeExpression() {
        return this.FirstOf(this.ListExpression(), this.MapExpression(), new Object[]{this.StringLiteral(), this.Boolean(), this.Double(), this.Integer(), this.Null()});
    }

    protected Rule DeclaredExpression() {
        return this.FirstOf(this.MapSelection(), this.Function(), new Object[]{this.Variable()});
    }

    Rule MapSelection() {
        return this.Sequence(this.Variable(), this.FreeSymbol(JtwigSymbol.OPEN_BRACKET), new Object[]{this.StringLiteral(), this.Spacing(), this.FreeSymbol(JtwigSymbol.CLOSE_BRACKET), this.push(new MapSelection((Variable)this.pop(1), (String)this.pop()))});
    }

    protected Rule Function() {
        return this.FirstOf(this.FunctionWithBrackets(), this.FunctionWithoutBrackets(), new Object[0]);
    }

    protected Rule FunctionWithBrackets() {
        return this.Sequence(this.Identifier(), this.Spacing(), new Object[]{this.push(new FunctionElement((String)this.pop())), this.FreeSymbol(JtwigSymbol.OPEN_PARENT), this.Optional(this.Arguments()), this.FreeSymbol(JtwigSymbol.CLOSE_PARENT)});
    }

    protected Rule FunctionWithoutBrackets() {
        return this.Sequence(this.Identifier(), this.Spacing(), new Object[]{this.push(new FunctionElement((String)this.pop())), this.Primary(), ((FunctionElement)this.peek(1)).add(this.pop())});
    }

    protected Rule Arguments() {
        return this.Sequence(this.Primary(), this.Spacing(), new Object[]{((Argumentable)this.peek(1)).add(this.pop()), this.ZeroOrMore(this.FreeSymbol(JtwigSymbol.COMMA), this.Primary(), new Object[]{this.Spacing(), ((Argumentable)this.peek(1)).add(this.pop())})});
    }

    Rule MapExpression() {
        return this.Sequence(this.FreeSymbol(JtwigSymbol.OPEN_CURLY_BRACKET), this.push(new ElementMap()), new Object[]{this.Optional(this.Identifier(), this.Spacing(), new Object[]{this.FreeSymbol(JtwigSymbol.DIV), this.BasicExpression(), this.Spacing(), ((ElementMap)this.peek(2)).add((String)this.pop(1), this.pop()), this.ZeroOrMore(this.FreeSymbol(JtwigSymbol.COMMA), this.Identifier(), new Object[]{this.Spacing(), this.FreeSymbol(JtwigSymbol.DIV), this.BasicExpression(), this.Spacing(), ((ElementMap)this.peek(2)).add((String)this.pop(1), this.pop())})}), this.FreeSymbol(JtwigSymbol.CLOSE_CURLY_BRACKET)});
    }

    protected Rule ComprehensionListExpression() {
        return this.FirstOf(this.ComprehensionIntegerListExpression(), this.ComprehensionCharacterListExpression(), new Object[0]);
    }

    protected Rule ComprehensionIntegerListExpression() {
        return this.Sequence(this.Integer(), this.Symbol(JtwigSymbol.TWO_DOTS), new Object[]{this.Integer(), this.push(new IntegerList((Integer)this.pop(1), (Integer)this.pop()))});
    }

    protected Rule ComprehensionCharacterListExpression() {
        return this.Sequence(this.Char(), this.Symbol(JtwigSymbol.TWO_DOTS), new Object[]{this.Char(), this.push(new CharacterList(((Character)this.pop(1)).charValue(), ((Character)this.pop()).charValue()))});
    }

    protected Rule EnumerationList() {
        return this.Sequence(this.FreeSymbol(JtwigSymbol.OPEN_BRACKET), this.push(new ValueList()), new Object[]{this.Optional(this.Expression(), this.Spacing(), new Object[]{((ElementList)this.peek(1)).add(this.pop()), this.ZeroOrMore(this.FreeSymbol(JtwigSymbol.COMMA), this.Expression(), new Object[]{this.Spacing(), ((ElementList)this.peek(1)).add(this.pop())})}), this.FreeSymbol(JtwigSymbol.CLOSE_BRACKET)});
    }

    protected Rule ListExpression() {
        return this.FirstOf(this.ComprehensionListExpression(), this.EnumerationList(), new Object[0]);
    }

    protected Rule Boolean() {
        return this.FirstOf(this.Sequence(this.SpecificKeyword(JtwigKeyword.TRUE), this.push(true), new Object[0]), this.Sequence(this.SpecificKeyword(JtwigKeyword.FALSE), this.push(false), new Object[0]), new Object[0]);
    }

    protected Rule Null() {
        return this.Sequence(this.SpecificKeyword(JtwigKeyword.NULL), this.push(null), new Object[0]);
    }

    protected Rule Integer() {
        return this.Sequence(this.Sequence(this.Optional(this.Symbol(JtwigSymbol.MINUS)), this.OneOrMore(this.Digit()), new Object[0]), this.push(Integer.parseInt(this.match())), new Object[0]);
    }

    protected Rule Char() {
        return this.Sequence(this.Symbol(JtwigSymbol.QUOTE), this.CharOnly(), new Object[]{this.push(Character.valueOf(this.match().charAt(0))), this.Symbol(JtwigSymbol.QUOTE)});
    }

    protected Rule Double() {
        return this.Sequence(this.Sequence(this.Optional(this.Symbol(JtwigSymbol.MINUS)), this.OneOrMore(this.Digit()), new Object[]{this.Symbol(JtwigSymbol.DOT), this.OneOrMore(this.Digit())}), this.push(Double.valueOf(this.match())), new Object[0]);
    }

    Rule Variable() {
        return this.Sequence(this.Identifier(), this.push(new Variable((String)this.pop())), new Object[0]);
    }

    protected Rule CloseCode() {
        return this.Symbol(JtwigSymbol.CLOSE_CODE);
    }

    protected Rule OpenCode() {
        return this.FreeSymbol(JtwigSymbol.OPEN_CODE);
    }

    protected Rule StringLiteral() {
        return this.FirstOf(this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.FirstOf(this.Escape(), this.Sequence(this.TestNot(this.AnyOf("\r\n\"\\")), ANY, new Object[0]), new Object[0])).suppressSubnodes(), new Object[]{this.push(this.match()), Character.valueOf('\"')}), this.Sequence("'", this.ZeroOrMore(this.FirstOf(this.Escape(), this.Sequence(this.TestNot(this.AnyOf("\r\n'\\")), ANY, new Object[0]), new Object[0])).suppressSubnodes(), new Object[]{this.push(this.match()), "'"}), new Object[0]);
    }

    Rule Escape() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("btnfr\"'\\"), this.OctalEscape(), new Object[]{this.UnicodeEscape()}), new Object[0]);
    }

    Rule OctalEscape() {
        return this.FirstOf(this.Sequence(this.CharRange('0', '3'), this.CharRange('0', '7'), new Object[]{this.CharRange('0', '7')}), this.Sequence(this.CharRange('0', '7'), this.CharRange('0', '7'), new Object[0]), new Object[]{this.CharRange('0', '7')});
    }

    Rule UnicodeEscape() {
        return this.Sequence(this.OneOrMore(Character.valueOf('u')), this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    Rule HexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.CharRange('0', '9')});
    }

    Rule Digit() {
        return this.CharRange('0', '9');
    }

    @SuppressSubnodes
    @MemoMismatches
    protected Rule Identifier() {
        return this.Sequence(this.IdentifierExpression(), this.push(this.match()), new Object[0]);
    }

    protected Rule IdentifierExpression() {
        return this.Sequence(this.TestNot(this.Keyword()), this.Letter(), new Object[]{this.ZeroOrMore(this.LetterOrDigit())});
    }

    @SuppressNode
    protected Rule Symbol(JtwigSymbol symbol) {
        return this.Terminal(symbol.getSymbol(), false);
    }

    @SuppressNode
    protected Rule FreeSymbol(JtwigSymbol symbol) {
        return this.Sequence(this.Terminal(symbol.getSymbol(), false), this.Optional(this.Spacing()), new Object[0]);
    }

    @SuppressNode
    protected Rule SpecificKeyword(JtwigKeyword keyword) {
        return this.Terminal(keyword.getKeyword(), this.LetterOrDigit());
    }

    @MemoMismatches
    protected Rule Keyword() {
        return this.Sequence(this.FirstOf(JtwigKeyword.keywords()), this.TestNot(this.LetterOrDigit()), new Object[0]);
    }

    protected Rule CharOnly() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[0]);
    }

    protected Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    @MemoMismatches
    protected Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }

    @SuppressNode
    @DontLabel
    protected Rule Terminal(String string) {
        return this.Sequence(string, this.Spacing(), new Object[0]).label('\'' + string + '\'');
    }

    @SuppressNode
    @DontLabel
    protected Rule Terminal(String string, boolean spacing) {
        if (spacing) {
            return this.Sequence(string, this.Spacing(), new Object[0]).label('\'' + string + '\'');
        }
        return this.String(string).label('\'' + string + '\'');
    }

    @SuppressNode
    @DontLabel
    protected Rule Terminal(String string, Rule mustNotFollow) {
        return this.Sequence(string, this.TestNot(mustNotFollow), new Object[]{this.Spacing()}).label('\'' + string + '\'');
    }

    @SuppressNode
    protected Rule Spacing() {
        return this.ZeroOrMore(this.FirstOf(this.OneOrMore(this.AnyOf(" \t\r\n\f").label("Whitespace")), this.Sequence("{#", this.ZeroOrMore(this.TestNot("#}"), ANY, new Object[0]), new Object[]{"#}"}), new Object[0]));
    }
}

