/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.content;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.functions.util.ObjectIterator;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Compilable;
import com.lyncode.jtwig.tree.api.Renderable;
import com.lyncode.jtwig.tree.content.Content;
import com.lyncode.jtwig.tree.structural.BlockExpression;
import com.lyncode.jtwig.tree.value.FunctionElement;
import com.lyncode.jtwig.tree.value.Variable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ForExpression
implements Renderable,
Compilable<ForExpression> {
    private Variable item;
    private Object list;
    private List<FunctionElement> filters = new ArrayList<FunctionElement>();
    private Content content;

    public ForExpression(Variable item, Object list) {
        this.item = item;
        this.list = list;
    }

    public boolean add(FunctionElement function) {
        this.filters.add(function);
        return true;
    }

    public Variable getItem() {
        return this.item;
    }

    public Object getList() {
        return this.list;
    }

    public List<FunctionElement> getFilters() {
        return this.filters;
    }

    public Content getContent() {
        return this.content;
    }

    public boolean setContent(Content content) {
        this.content = content;
        return true;
    }

    @Override
    public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
        try {
            ObjectIterator iterator = new ObjectIterator(context.resolve(this.list));
            Loop loop = new Loop(iterator.size());
            context.set("loop", loop);
            int index = 0;
            while (iterator.hasNext()) {
                loop.update(index++);
                Object object = iterator.next();
                context.set(this.item.getIdentifier(), object);
                this.content.render(outputStream, context);
            }
            return true;
        }
        catch (CalculateException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public ForExpression compile(JtwigResource resource) throws CompileException {
        this.content = this.content.compile(resource);
        return this;
    }

    @Override
    public boolean replace(BlockExpression expression) throws CompileException {
        return this.content.replace(expression);
    }

    public String toString() {
        return "For each element of " + this.list + " render " + this.content;
    }

    public static class Loop {
        private int index = 0;
        private int length;

        public Loop(int length) {
            this.length = length;
        }

        public void update(int index) {
            this.index = index;
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRevindex() {
            return this.length - this.index - 1;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.length - 1;
        }
    }
}

