/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.content;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Compilable;
import com.lyncode.jtwig.tree.api.Renderable;
import com.lyncode.jtwig.tree.content.Content;
import com.lyncode.jtwig.tree.structural.BlockExpression;
import com.lyncode.jtwig.tree.value.Variable;
import java.io.OutputStream;
import java.util.Map;

public class ForPairExpression
implements Renderable,
Compilable<ForPairExpression> {
    private Variable key;
    private Variable value;
    private Object map;
    private Content content;

    public ForPairExpression(Variable key, Variable value, Object map) {
        this.key = key;
        this.value = value;
        this.map = map;
    }

    public Variable getKey() {
        return this.key;
    }

    public Object getMap() {
        return this.map;
    }

    public Content getContent() {
        return this.content;
    }

    public boolean setContent(Content content) {
        this.content = content;
        return true;
    }

    @Override
    public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
        try {
            Object resolved = context.resolve(this.map);
            if (!(resolved instanceof Map)) {
                throw new RenderException("Expecting a map as parameter for the loop but " + this.map + " was given");
            }
            Map map = (Map)resolved;
            Loop loop = new Loop(map.size());
            context.set("loop", loop);
            int index = 0;
            for (Object key : map.keySet()) {
                loop.update(index++);
                context.set(this.key.getIdentifier(), key);
                context.set(this.value.getIdentifier(), map.get(key));
                this.content.render(outputStream, context);
            }
            return true;
        }
        catch (CalculateException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public ForPairExpression compile(JtwigResource resource) throws CompileException {
        this.content = this.content.compile(resource);
        return this;
    }

    @Override
    public boolean replace(BlockExpression expression) throws CompileException {
        return this.content.replace(expression);
    }

    public String toString() {
        return "For each element of " + this.map + " render " + this.content;
    }

    public static class Loop {
        private int index = 0;
        private int length;

        public Loop(int length) {
            this.length = length;
        }

        public void update(int index) {
            this.index = index;
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRevindex() {
            return this.length - this.index - 1;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.length - 1;
        }
    }
}

