/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.documents;

import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.parser.JtwigParser;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.content.Content;
import com.lyncode.jtwig.tree.documents.JtwigDocument;
import com.lyncode.jtwig.tree.structural.BlockExpression;
import com.lyncode.jtwig.tree.structural.ExtendsExpression;
import java.util.ArrayList;
import java.util.List;

public class JtwigExtendsDocument
implements JtwigDocument {
    private ExtendsExpression extendsExpression;
    private List<BlockExpression> blocks = new ArrayList<BlockExpression>();

    public JtwigExtendsDocument(ExtendsExpression extendsExpression) {
        this.extendsExpression = extendsExpression;
    }

    public boolean add(BlockExpression blockExpression) {
        this.blocks.add(blockExpression);
        return true;
    }

    @Override
    public Content compile(JtwigResource resource) throws CompileException {
        try {
            for (int i = 0; i < this.blocks.size(); ++i) {
                this.blocks.set(i, this.blocks.get(i).compile(resource));
            }
            JtwigResource jtwigResource = resource.resolve(this.extendsExpression.getPath());
            Content content = (Content)JtwigParser.parse(jtwigResource).compile(jtwigResource);
            for (BlockExpression expression : this.blocks) {
                content.replace(expression);
            }
            return content;
        }
        catch (ResourceException e) {
            throw new CompileException(e);
        }
        catch (ParseException e) {
            throw new CompileException(e);
        }
    }

    @Override
    public boolean replace(BlockExpression expression) throws CompileException {
        boolean replaced = false;
        for (BlockExpression container : this.blocks) {
            replaced = replaced || container.replace(expression);
        }
        return replaced;
    }
}

