/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.helper;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.util.ObjectIterator;
import com.lyncode.jtwig.tree.api.Calculable;
import com.lyncode.jtwig.tree.value.OperationBinary;
import com.lyncode.jtwig.tree.value.Operator;
import com.lyncode.jtwig.util.BooleanOperations;
import com.lyncode.jtwig.util.MathOperations;
import com.lyncode.jtwig.util.RelationalOperations;

public class StrictBinaryOperation
implements Calculable {
    private Operator operator;
    private Object left;
    private Object right;

    public static StrictBinaryOperation create(OperationBinary binary) {
        int index = 0;
        StrictBinaryOperation last = null;
        for (Operator operator : binary.getOperators()) {
            StrictBinaryOperation operation = new StrictBinaryOperation();
            operation.operator = operator;
            operation.left = last != null ? last : binary.getOperands().getList().get(index);
            operation.right = binary.getOperands().getList().get(index + 1);
            last = operation;
            ++index;
        }
        return last;
    }

    private Object numericExecute(JtwigContext resolver) throws CalculateException {
        switch (this.operator) {
            case ADD: {
                return MathOperations.sum(resolver.resolve(this.left), resolver.resolve(this.right));
            }
            case SUB: {
                return MathOperations.sub(resolver.resolve(this.left), resolver.resolve(this.right));
            }
            case DIV: {
                return MathOperations.div(resolver.resolve(this.left), resolver.resolve(this.right));
            }
            case TIMES: {
                return MathOperations.mul(resolver.resolve(this.left), resolver.resolve(this.right));
            }
            case MOD: {
                return MathOperations.mod(resolver.resolve(this.left), resolver.resolve(this.right));
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    private Object relationalExecute(JtwigContext resolver) throws CalculateException {
        Object leftResolved = resolver.resolve(this.left);
        Object rightResolved = resolver.resolve(this.right);
        switch (this.operator) {
            case GT: {
                return RelationalOperations.gt(leftResolved, rightResolved);
            }
            case GTE: {
                return RelationalOperations.gte(leftResolved, rightResolved);
            }
            case LT: {
                return RelationalOperations.lt(leftResolved, rightResolved);
            }
            case LTE: {
                return RelationalOperations.lte(leftResolved, rightResolved);
            }
            case EQUAL: {
                return RelationalOperations.eq(leftResolved, rightResolved);
            }
            case DIFF: {
                return RelationalOperations.neq(leftResolved, rightResolved);
            }
            case STARTS_WITH: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().startsWith(rightResolved.toString());
            }
            case ENDS_WITH: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().endsWith(rightResolved.toString());
            }
            case MATCHES: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().matches(rightResolved.toString());
            }
            case IN: {
                if (rightResolved == null) {
                    return false;
                }
                if (rightResolved instanceof Iterable || rightResolved.getClass().isArray()) {
                    return new ObjectIterator(rightResolved).contains(leftResolved);
                }
                if (rightResolved instanceof String) {
                    return ((String)rightResolved).contains(leftResolved.toString());
                }
                return false;
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    private Object booleanExecute(JtwigContext resolver) throws CalculateException {
        switch (this.operator) {
            case AND: {
                return BooleanOperations.and(resolver.resolve(this.left), resolver.resolve(this.right));
            }
            case OR: {
                return BooleanOperations.or(resolver.resolve(this.left), resolver.resolve(this.right));
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        switch (this.operator) {
            case ADD: 
            case SUB: 
            case DIV: 
            case TIMES: 
            case MOD: 
            case INT_DIV: 
            case INT_TIMES: {
                return this.numericExecute(context);
            }
            case AND: 
            case OR: {
                return this.booleanExecute(context);
            }
        }
        return this.relationalExecute(context);
    }
}

