/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.value;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.tree.api.Argumentable;
import com.lyncode.jtwig.tree.api.Calculable;
import com.lyncode.jtwig.tree.api.Element;
import com.lyncode.jtwig.tree.value.ValueList;
import java.util.List;

public class FunctionElement
implements Element,
Argumentable,
Calculable {
    private String name;
    private ValueList arguments;

    public FunctionElement(String name) {
        this.name = name;
        this.arguments = new ValueList();
    }

    @Override
    public boolean add(Object argument) {
        return this.arguments.add(argument);
    }

    public String getName() {
        return this.name;
    }

    public ValueList getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.name + this.arguments;
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        try {
            return context.function(this.getName()).execute(this.arguments(context));
        }
        catch (FunctionException e) {
            throw new CalculateException(e);
        }
        catch (FunctionNotFoundException e) {
            throw new CalculateException(e);
        }
    }

    private Object[] arguments(JtwigContext context) throws CalculateException {
        return ((List)this.arguments.calculate(context)).toArray();
    }
}

