/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.date;

import com.lyncode.jtwig.functions.Function;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;

public class DateModify
implements Function {
    private static final String PATTERN = "^([\\\\+\\\\-])([0-9]+) ([a-zA-Z]+)$";

    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments((org.hamcrest.Matcher<Integer>)CoreMatchers.equalTo((Object)2)).withArgument(0, (org.hamcrest.Matcher<Object>)CoreMatchers.instanceOf(Date.class)).withArgument(1, (org.hamcrest.Matcher<Object>)CoreMatchers.notNullValue()).withArgument(1, (org.hamcrest.Matcher<Object>)this.hasPattern(PATTERN));
        Calendar instance = Calendar.getInstance();
        instance.setTime((Date)arguments[0]);
        String modifyString = arguments[1].toString().trim();
        Matcher matcher = Pattern.compile(PATTERN).matcher(modifyString);
        matcher.find();
        int signal = 1;
        if (matcher.group(1).equals("-")) {
            signal = -1;
        }
        int val = Integer.valueOf(matcher.group(2)) * signal;
        String type = matcher.group(3).toLowerCase();
        if (type.startsWith("day")) {
            instance.add(6, val);
        } else if (type.startsWith("month")) {
            instance.add(2, val);
        } else if (type.startsWith("year")) {
            instance.add(1, val);
        } else if (type.startsWith("second")) {
            instance.add(13, val);
        } else if (type.startsWith("hour")) {
            instance.add(10, val);
        } else if (type.startsWith("minute")) {
            instance.add(12, val);
        } else {
            throw new FunctionException("Unknown type " + matcher.group(3));
        }
        return instance.getTime();
    }

    private BaseMatcher<Object> hasPattern(final String pattern) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return item.toString().matches(pattern);
            }

            public void describeTo(Description description) {
                description.appendText("matches pattern ").appendValue((Object)pattern);
            }
        };
    }
}

