/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.string;

import com.lyncode.jtwig.functions.Function;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class Escape
implements Function {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments(Requirements.between(1, 2));
        String strategy = "html";
        if (arguments.length == 2) {
            strategy = arguments[1].toString().toLowerCase();
        }
        switch (EscapeStrategy.strategyByName(strategy.toLowerCase())) {
            case HTML: {
                return StringEscapeUtils.escapeHtml4((String)arguments[0].toString());
            }
            case JAVASCRIPT: {
                return StringEscapeUtils.escapeEcmaScript((String)arguments[0].toString());
            }
            case XML: {
                return StringEscapeUtils.escapeXml((String)arguments[0].toString());
            }
        }
        throw new FunctionException("Unknown escaping strategy");
    }

    public static enum EscapeStrategy {
        HTML("html"),
        JAVASCRIPT("js", "javascript"),
        XML("xml");

        private List<String> representations;

        private EscapeStrategy(String ... representations) {
            this.representations = Arrays.asList(representations);
        }

        public static EscapeStrategy strategyByName(String name) {
            for (EscapeStrategy escape : EscapeStrategy.values()) {
                if (!escape.representations.contains(name)) continue;
                return escape;
            }
            return null;
        }
    }
}

