/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.repository;

import com.lyncode.jtwig.functions.Function;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.internal.cast.ToDouble;
import com.lyncode.jtwig.functions.internal.cast.ToInt;
import com.lyncode.jtwig.functions.internal.date.DateFormat;
import com.lyncode.jtwig.functions.internal.date.DateModify;
import com.lyncode.jtwig.functions.internal.generic.Default;
import com.lyncode.jtwig.functions.internal.generic.First;
import com.lyncode.jtwig.functions.internal.generic.JsonEncode;
import com.lyncode.jtwig.functions.internal.generic.Last;
import com.lyncode.jtwig.functions.internal.generic.Length;
import com.lyncode.jtwig.functions.internal.generic.Reverse;
import com.lyncode.jtwig.functions.internal.list.Batch;
import com.lyncode.jtwig.functions.internal.list.Concatenate;
import com.lyncode.jtwig.functions.internal.list.Join;
import com.lyncode.jtwig.functions.internal.list.Merge;
import com.lyncode.jtwig.functions.internal.list.Slice;
import com.lyncode.jtwig.functions.internal.map.MapKeys;
import com.lyncode.jtwig.functions.internal.math.Abs;
import com.lyncode.jtwig.functions.internal.math.JNumberFormat;
import com.lyncode.jtwig.functions.internal.math.Round;
import com.lyncode.jtwig.functions.internal.string.Capitalize;
import com.lyncode.jtwig.functions.internal.string.ConvertEncoding;
import com.lyncode.jtwig.functions.internal.string.Escape;
import com.lyncode.jtwig.functions.internal.string.Format;
import com.lyncode.jtwig.functions.internal.string.Lower;
import com.lyncode.jtwig.functions.internal.string.Nl2Br;
import com.lyncode.jtwig.functions.internal.string.Replace;
import com.lyncode.jtwig.functions.internal.string.Split;
import com.lyncode.jtwig.functions.internal.string.StripTags;
import com.lyncode.jtwig.functions.internal.string.Title;
import com.lyncode.jtwig.functions.internal.string.Trim;
import com.lyncode.jtwig.functions.internal.string.Upper;
import com.lyncode.jtwig.functions.internal.string.UrlEncode;
import com.lyncode.jtwig.functions.repository.FunctionDeclaration;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFunctionRepository {
    private Map<String, Function> functionMap = new HashMap<String, Function>();

    public AbstractFunctionRepository(FunctionDeclaration ... functions) {
        this.addFunctions(new FunctionDeclaration(new Concatenate(), "concat", "concatenate"), new FunctionDeclaration(new Join(), "join", new String[0]), new FunctionDeclaration(new Batch(), "batch", new String[0]), new FunctionDeclaration(new Merge(), "merge", new String[0]), new FunctionDeclaration(new Slice(), "slice", new String[0]), new FunctionDeclaration(new MapKeys(), "keys", new String[0]), new FunctionDeclaration(new Upper(), "upper", new String[0]), new FunctionDeclaration(new Lower(), "lower", new String[0]), new FunctionDeclaration(new StripTags(), "striptags", new String[0]), new FunctionDeclaration(new Trim(), "trim", new String[0]), new FunctionDeclaration(new Split(), "split", new String[0]), new FunctionDeclaration(new Capitalize(), "capitalize", new String[0]), new FunctionDeclaration(new Title(), "title", new String[0]), new FunctionDeclaration(new Replace(), "replace", new String[0]), new FunctionDeclaration(new Format(), "format", new String[0]), new FunctionDeclaration(new Nl2Br(), "nl2br", new String[0]), new FunctionDeclaration(new UrlEncode(), "url_encode", new String[0]), new FunctionDeclaration(new Escape(), "escape", "e"), new FunctionDeclaration(new DateModify(), "date_modify", new String[0]), new FunctionDeclaration(new DateFormat(), "date", "date_format"), new FunctionDeclaration(new ConvertEncoding(), "convert_encoding", new String[0]), new FunctionDeclaration(new Abs(), "abs", new String[0]), new FunctionDeclaration(new JNumberFormat(), "number_format", new String[0]), new FunctionDeclaration(new Round(), "round", new String[0]), new FunctionDeclaration(new ToDouble(), "toDouble", "toFloat"), new FunctionDeclaration(new ToInt(), "toInt", new String[0]), new FunctionDeclaration(new Length(), "length", new String[0]), new FunctionDeclaration(new Default(), "default", new String[0]), new FunctionDeclaration(new First(), "first", new String[0]), new FunctionDeclaration(new Last(), "last", new String[0]), new FunctionDeclaration(new JsonEncode(), "json_encode", new String[0]), new FunctionDeclaration(new Reverse(), "reverse", new String[0]));
        this.addFunctions(functions);
    }

    private void addFunctions(FunctionDeclaration ... functions) {
        for (FunctionDeclaration declaration : functions) {
            for (String alias : declaration.getAliases()) {
                this.functionMap.put(alias, declaration.getFunction());
            }
        }
    }

    public Function retrieve(String functionName) throws FunctionNotFoundException {
        if (!this.functionMap.containsKey(functionName)) {
            throw new FunctionNotFoundException();
        }
        return this.functionMap.get(functionName);
    }
}

