/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.CastMatcher;
import com.lyncode.jtwig.types.Undefined;
import java.util.Collection;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.AnyOf;

public class BooleanFunctions {
    @JtwigFunction(name="constant")
    public boolean isEqualToConstant(@Parameter Object value, @Parameter String constant) throws FunctionException {
        int constantNamePosition = constant.lastIndexOf(".");
        if (constantNamePosition == -1) {
            throw new FunctionException(String.format("Invalid constant specified '%s'", constant));
        }
        String className = constant.substring(0, constantNamePosition);
        String constantName = constant.substring(constantNamePosition + 1);
        try {
            return value.equals(Class.forName(className).getDeclaredField(constantName).get(null));
        }
        catch (Exception e) {
            throw new FunctionException(String.format("Constant '%s' does not exist", constant));
        }
    }

    @JtwigFunction(name="defined")
    public boolean isDefined(@Parameter Object value) {
        return !Undefined.UNDEFINED.equals(value);
    }

    @JtwigFunction(name="divisable by")
    public boolean isDivisableBy(@Parameter Number value, @Parameter Number dividend) {
        double value2;
        double value1 = value.doubleValue();
        return value1 % (value2 = dividend.doubleValue()) == 0.0;
    }

    @JtwigFunction(name="even")
    public boolean even(@Parameter int number) {
        return number % 2 == 0;
    }

    @JtwigFunction(name="odd")
    public boolean odd(@Parameter int number) {
        return number % 2 == 1;
    }

    @JtwigFunction(name="null")
    public boolean isNull(@Parameter Object input) {
        return input == null || input instanceof Undefined;
    }

    @JtwigFunction(name="iterable")
    public boolean iterable(@Parameter Object input) {
        return input instanceof Iterable || input.getClass().isArray() || input instanceof Map;
    }

    @JtwigFunction(name="empty")
    public boolean isEmpty(@Parameter Object input) {
        return AnyOf.anyOf((Matcher)CoreMatchers.nullValue(Object.class), this.emptyCollection(), this.emptyMap(), this.notHasNext(), this.zeroValue()).matches(input);
    }

    private Matcher<Object> emptyMap() {
        return new CastMatcher<Map>(Map.class, (Matcher<Map>)new FeatureMatcher<Map, Collection>(this.emptyCollection(), "empty list", "empty list"){

            protected Collection featureValueOf(Map actual) {
                return actual.keySet();
            }
        });
    }

    private Matcher<Object> zeroValue() {
        return new CastMatcher<Integer>(Integer.class, CoreMatchers.equalTo((Object)0));
    }

    private Matcher<Object> emptyCollection() {
        return new CastMatcher<Collection>(Collection.class, IsEmptyCollection.empty());
    }

    private Matcher<Object> notHasNext() {
        return new CastMatcher<Iterable>(Iterable.class, (Matcher<Iterable>)new FeatureMatcher<Iterable, Boolean>(CoreMatchers.equalTo((Object)false), "has next", "has next"){

            protected Boolean featureValueOf(Iterable actual) {
                return actual.iterator().hasNext();
            }
        });
    }
}

