/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.ObjectIterator;
import com.lyncode.jtwig.functions.util.ObjectUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ListFunctions {
    @JtwigFunction(name="batch")
    public List<List<Object>> batch(@Parameter Object input, @Parameter int groupSize) {
        ObjectIterator iterator = new ObjectIterator(input);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (!iterator.hasNext()) continue;
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    @JtwigFunction(name="batch")
    public List<List<Object>> batch(@Parameter Object input, @Parameter int groupSize, @Parameter Object padding) {
        ObjectIterator iterator = new ObjectIterator(input);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (iterator.hasNext()) {
                    batch.add(iterator.next());
                    continue;
                }
                batch.add(padding);
            }
            result.add(batch);
        }
        return result;
    }

    @JtwigFunction(name="concat", aliases={"concatenate"})
    public String concatenate(String ... pieces) {
        StringBuilder builder = new StringBuilder();
        for (String piece : pieces) {
            if (piece == null) continue;
            builder.append(piece);
        }
        return builder.toString();
    }

    @JtwigFunction(name="join")
    public String join(@Parameter Object input, @Parameter String separator) {
        ArrayList<String> pieces = new ArrayList<String>();
        ObjectIterator iterator = new ObjectIterator(input);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) {
                pieces.add("");
                continue;
            }
            pieces.add(next.toString());
        }
        return StringUtils.join(pieces, (String)separator);
    }

    @JtwigFunction(name="join")
    public String join(@Parameter Object input) {
        return this.join(input, "");
    }

    @JtwigFunction(name="merge")
    public Object merge(@Parameter Object first, Object ... rest) {
        if (first instanceof Iterable) {
            return this.mergeList(first, rest);
        }
        if (first instanceof Map) {
            return this.mergeMap(first, rest);
        }
        return this.mergeArray(first, rest);
    }

    @JtwigFunction(name="length")
    public int length(@Parameter Iterable input) {
        Iterator iterator = input.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @JtwigFunction(name="first")
    public Object first(@Parameter List input) {
        if (input.isEmpty()) {
            return null;
        }
        return input.get(0);
    }

    @JtwigFunction(name="last")
    public Object last(@Parameter List input) {
        if (input.isEmpty()) {
            return null;
        }
        return input.get(input.size() - 1);
    }

    @JtwigFunction(name="reverse")
    public List reverse(@Parameter Object input) {
        ObjectIterator objectIterator = new ObjectIterator(input);
        ArrayList<Object> result = new ArrayList<Object>();
        while (objectIterator.hasNext()) {
            result.add(objectIterator.next());
        }
        Collections.reverse(result);
        return result;
    }

    @JtwigFunction(name="slice")
    public Object slice(@Parameter Object input, @Parameter int begin, @Parameter int length) throws FunctionException {
        if (input instanceof String) {
            String value = (String)input;
            if (value.length() < begin) {
                return "";
            }
            return value.substring(begin, Math.min(value.length(), begin + length));
        }
        ObjectIterator iterator = new ObjectIterator(input);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= begin && i < begin + length) {
                list.add(iterator.next());
            } else {
                iterator.next();
            }
            ++i;
        }
        if (input instanceof Iterable) {
            return list;
        }
        return list.toArray();
    }

    @JtwigFunction(name="sort")
    public List sort(@Parameter List input) {
        Collections.sort(input);
        return input;
    }

    @JtwigFunction(name="max")
    public Object max(Object ... values) {
        Object result = values[0];
        for (Object value : values = ArrayUtils.remove((Object[])values, (int)0)) {
            int cmp = ObjectUtils.compare(result, value);
            if (cmp >= 0) continue;
            result = value;
        }
        return result;
    }

    @JtwigFunction(name="min")
    public Object min(Object ... values) {
        Object result = values[0];
        for (Object value : values = ArrayUtils.remove((Object[])values, (int)0)) {
            int cmp = ObjectUtils.compare(result, value);
            if (cmp <= 0) continue;
            result = value;
        }
        return result;
    }

    private Object mergeArray(Object first, Object ... arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : (Object[])first) {
            result.add(obj);
        }
        for (Object obj : arguments) {
            Object[] list;
            if (obj == null) continue;
            for (Object value : list = (Object[])obj) {
                result.add(value);
            }
        }
        return result.toArray();
    }

    private Object mergeMap(Object first, Object ... arguments) {
        AbstractMap result = first instanceof TreeMap ? new TreeMap() : new HashMap();
        result.putAll((Map)first);
        for (Object obj : arguments) {
            if (obj == null) continue;
            result.putAll((Map)obj);
        }
        return result;
    }

    private Object mergeList(Object first, Object ... arguments) {
        ArrayList result = new ArrayList();
        result.addAll((List)first);
        for (Object obj : arguments) {
            if (obj == null) continue;
            result.addAll((List)obj);
        }
        return result;
    }
}

