/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.HtmlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class StringFunctions {
    @JtwigFunction(name="capitalize")
    public String capitalize(@Parameter String input) {
        if (input.length() > 0) {
            return input.substring(0, 1).toUpperCase() + input.substring(1);
        }
        return input;
    }

    @JtwigFunction(name="convert_encoding")
    public String convertEncoding(@Parameter String input, @Parameter String from, @Parameter String to) {
        return new String(input.getBytes(Charset.forName(from)), Charset.forName(to));
    }

    @JtwigFunction(name="escape", aliases={"e"})
    public String escape(@Parameter String input) throws FunctionException {
        return this.escape(input, EscapeStrategy.HTML.name());
    }

    @JtwigFunction(name="escape", aliases={"e"})
    public String escape(@Parameter String input, @Parameter String strategy) throws FunctionException {
        switch (EscapeStrategy.strategyByName(strategy.toLowerCase())) {
            case JAVASCRIPT: {
                return StringEscapeUtils.escapeEcmaScript((String)input);
            }
            case XML: {
                return StringEscapeUtils.escapeXml((String)input);
            }
        }
        return StringEscapeUtils.escapeHtml4((String)input);
    }

    @JtwigFunction(name="format")
    public String format(@Parameter String input, Object ... arguments) {
        return String.format(input, arguments);
    }

    @JtwigFunction(name="lower")
    public String lower(@Parameter String input) {
        return input.toLowerCase();
    }

    @JtwigFunction(name="nl2br")
    public String nl2br(@Parameter String input) {
        return input.replace("\n", "<br />");
    }

    @JtwigFunction(name="replace")
    public String replace(@Parameter String input, @Parameter Map<String, Object> replacements) {
        for (String key : replacements.keySet()) {
            if (!replacements.containsKey(key)) continue;
            input = input.replace(key, replacements.get(key).toString());
        }
        return input;
    }

    private boolean test(Map<String, Object> replacements, String key) {
        return replacements.containsKey(key);
    }

    @JtwigFunction(name="split")
    public List<String> split(@Parameter String input, @Parameter String separator) {
        return Arrays.asList(input.split(separator));
    }

    @JtwigFunction(name="striptags")
    public String stripTags(@Parameter String input) {
        return this.stripTags(input, "");
    }

    @JtwigFunction(name="striptags")
    public String stripTags(@Parameter String input, @Parameter String allowedTags) {
        return HtmlUtils.stripTags(input, allowedTags);
    }

    @JtwigFunction(name="title")
    public String title(@Parameter String input) {
        return WordUtils.capitalize((String)input);
    }

    @JtwigFunction(name="trim")
    public String trim(@Parameter String input) {
        return input == null ? null : input.trim();
    }

    @JtwigFunction(name="upper")
    public String upper(@Parameter String input) {
        return input.toUpperCase();
    }

    @JtwigFunction(name="url_encode")
    public String urlEncode(@Parameter String input) throws UnsupportedEncodingException {
        return URLEncoder.encode(input, Charset.defaultCharset().displayName());
    }

    @JtwigFunction(name="url_encode")
    public String urlEncode(@Parameter Map input) throws UnsupportedEncodingException {
        ArrayList<String> pieces = new ArrayList<String>();
        for (Object key : input.keySet()) {
            pieces.add(this.urlEncode(key.toString()) + "=" + this.urlEncode(input.get(key).toString()));
        }
        return StringUtils.join(pieces, (String)"&");
    }

    @JtwigFunction(name="first")
    public Character first(@Parameter String input) {
        if (input.isEmpty()) {
            return null;
        }
        return Character.valueOf(input.charAt(0));
    }

    @JtwigFunction(name="last")
    public Character last(@Parameter String input) {
        if (input.isEmpty()) {
            return null;
        }
        return Character.valueOf(input.charAt(input.length() - 1));
    }

    @JtwigFunction(name="reverse")
    public String reverse(@Parameter String input) {
        return new StringBuilder(input).reverse().toString();
    }

    static enum EscapeStrategy {
        HTML("html"),
        JAVASCRIPT("js", "javascript"),
        XML("xml");

        private List<String> representations;

        private EscapeStrategy(String ... representations) {
            this.representations = Arrays.asList(representations);
        }

        public static EscapeStrategy strategyByName(String name) {
            for (EscapeStrategy escape : EscapeStrategy.values()) {
                if (!escape.representations.contains(name)) continue;
                return escape;
            }
            throw new IllegalStateException(String.format("Unknown strategy '%s'", name));
        }
    }
}

