/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.json;

import com.google.common.base.Function;
import com.lyncode.jtwig.functions.json.JsonMapperProvider;
import com.lyncode.jtwig.functions.json.JsonMappingException;
import com.lyncode.jtwig.functions.json.provider.GsonJsonMapperProvider;
import com.lyncode.jtwig.functions.json.provider.JacksonCodehausJsonMapperProvider;
import com.lyncode.jtwig.functions.json.provider.JacksonFasterXmlJsonMapperProvider;
import com.lyncode.jtwig.functions.util.ClassUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultJsonMapper
implements Function<Object, String> {
    private static List<JsonMapperProvider> providers = Arrays.asList(new JacksonFasterXmlJsonMapperProvider(), new JacksonCodehausJsonMapperProvider(), new GsonJsonMapperProvider());
    private Function<Object, String> implementation;

    public DefaultJsonMapper() {
        for (JsonMapperProvider provider : providers) {
            if (!ClassUtils.classExists(DefaultJsonMapper.class.getClassLoader(), provider.className())) continue;
            this.implementation = provider.jsonMapper();
            return;
        }
        this.implementation = new Function<Object, String>(){

            @Nullable
            public String apply(@Nullable Object input) {
                throw new JsonMappingException("No json mapper found in the project. Try to add jackson, jackson2 or gson to your classpath.");
            }
        };
    }

    @Nullable
    public String apply(@Nullable Object input) {
        return (String)this.implementation.apply(input);
    }
}

