/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.parameters.resolve.impl;

import com.google.common.base.Optional;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.parameters.convert.DemultiplexerConverter;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.parameters.resolve.api.ParameterResolver;
import com.lyncode.jtwig.functions.reflection.JavaMethodParameter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.commons.lang3.ClassUtils;

public class ParameterAnnotationParameterResolver
implements ParameterResolver {
    private final InputParameters input;
    private final DemultiplexerConverter converter;

    public ParameterAnnotationParameterResolver(InputParameters input, DemultiplexerConverter converter) {
        this.input = input;
        this.converter = converter;
    }

    @Override
    public Optional<ParameterResolver.Value> resolve(JavaMethodParameter parameter) {
        if (parameter.hasAnnotation(Parameter.class)) {
            if (parameter.isVarArg()) {
                Class<?> componentType = parameter.type().getComponentType();
                ArrayList<Object> args = new ArrayList<Object>();
                for (int i = parameter.annotationIndex(Parameter.class); i < this.input.length(); ++i) {
                    Object value = this.input.valueAt(i);
                    if (value == null) {
                        args.add(value);
                        continue;
                    }
                    if (ClassUtils.isAssignable(value.getClass(), componentType)) {
                        args.add(value);
                        continue;
                    }
                    Optional convert = this.converter.convert(value, componentType);
                    if (convert.isPresent()) {
                        args.add(convert.get());
                        continue;
                    }
                    return Optional.absent();
                }
                Object newInstance = Array.newInstance(componentType, args.size());
                for (int i = 0; i < args.size(); ++i) {
                    Array.set(newInstance, i, args.get(i));
                }
                return Optional.of((Object)new ParameterResolver.Value(newInstance));
            }
            int index = parameter.annotationIndex(Parameter.class);
            Object value = this.input.valueAt(index);
            if (value == null) {
                return Optional.of((Object)new ParameterResolver.Value(null));
            }
            if (ClassUtils.isAssignable(value.getClass(), parameter.type())) {
                return Optional.of((Object)new ParameterResolver.Value(value));
            }
            Optional convert = this.converter.convert(value, parameter.type());
            if (convert.isPresent()) {
                return Optional.of((Object)new ParameterResolver.Value(convert.get()));
            }
        }
        return Optional.absent();
    }
}

