/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.repository.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.builtin.BooleanFunctions;
import com.lyncode.jtwig.functions.builtin.DateFunctions;
import com.lyncode.jtwig.functions.builtin.JsonFunctions;
import com.lyncode.jtwig.functions.builtin.ListFunctions;
import com.lyncode.jtwig.functions.builtin.MapFunctions;
import com.lyncode.jtwig.functions.builtin.MathFunctions;
import com.lyncode.jtwig.functions.builtin.NumberFunctions;
import com.lyncode.jtwig.functions.builtin.ObjectFunctions;
import com.lyncode.jtwig.functions.builtin.StringFunctions;
import com.lyncode.jtwig.functions.config.JsonConfiguration;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.repository.api.FunctionRepository;
import com.lyncode.jtwig.functions.repository.model.Function;
import com.lyncode.jtwig.functions.util.SortedList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class MapFunctionRepository
implements FunctionRepository {
    private final ConcurrentHashMap<String, Collection<Function>> repository = new ConcurrentHashMap();

    public MapFunctionRepository(JsonConfiguration configuration) {
        this.include(new BooleanFunctions());
        this.include(new DateFunctions());
        this.include(new ListFunctions());
        this.include(new MapFunctions());
        this.include(new MathFunctions());
        this.include(new NumberFunctions());
        this.include(new ObjectFunctions());
        this.include(new StringFunctions());
        this.include(new JsonFunctions(configuration));
    }

    @Override
    public FunctionRepository include(Object instance) {
        for (Method method : instance.getClass().getDeclaredMethods()) {
            JtwigFunction annotation = method.getAnnotation(JtwigFunction.class);
            if (annotation == null) continue;
            this.add(annotation.name(), Function.functionFrom(method).on(instance));
            this.aliases(annotation.name(), annotation.aliases());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionRepository add(String name, Function function) {
        ConcurrentHashMap<String, Collection<Function>> concurrentHashMap = this.repository;
        synchronized (concurrentHashMap) {
            if (!this.repository.containsKey(name)) {
                this.repository.put(name, new SortedList());
            }
        }
        this.repository.get(name).add(function);
        return this;
    }

    @Override
    public FunctionRepository aliases(String name, String[] aliases) {
        for (String alias : aliases) {
            this.repository.putIfAbsent(alias, this.repository.get(name));
        }
        return this;
    }

    @Override
    public boolean containsFunctionName(String name) {
        return this.repository.containsKey(name);
    }

    @Override
    public Collection<Function> retrieve(String name, InputParameters parameters) {
        Collection<Function> functions = this.repository.get(name);
        if (functions == null) {
            return new ArrayList<Function>();
        }
        return Collections2.filter(functions, (Predicate)Predicates.or((Predicate)Predicates.and(this.isVarArg(), this.numberOfArgumentsAnnotatedWithParameter((Predicate<Integer>)Range.lessThan((Comparable)Integer.valueOf(parameters.length())))), this.numberOfArgumentsAnnotatedWithParameter((Predicate<Integer>)Predicates.equalTo((Object)parameters.length()))));
    }

    private Predicate<? super Function> isVarArg() {
        return new Predicate<Function>(){

            public boolean apply(@Nullable Function input) {
                return input.method().isVarArgs();
            }
        };
    }

    private Predicate<? super Function> numberOfArgumentsAnnotatedWithParameter(final Predicate<Integer> integerPredicate) {
        return new Predicate<Function>(){

            public boolean apply(@Nullable Function input) {
                int size = input.getParameterTypesWithAnnotation(Parameter.class).size();
                if (input.method().isVarArgs()) {
                    --size;
                }
                return integerPredicate.apply((Object)size);
            }
        };
    }
}

