/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class SortedList<T extends Comparable<T>>
extends LinkedList<T> {
    private final Comparator<T> comparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    };

    @Override
    public boolean add(T paramT) {
        int insertionPoint = Collections.binarySearch(this, paramT, this.comparator);
        super.add(insertionPoint > -1 ? insertionPoint : -insertionPoint - 1, paramT);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> paramCollection) {
        boolean result = false;
        if (paramCollection.size() > 4) {
            result = super.addAll(paramCollection);
            Collections.sort(this, this.comparator);
        } else {
            for (Comparable paramT : paramCollection) {
                result |= this.add((T)paramT);
            }
        }
        return result;
    }

    public boolean containsElement(T paramT) {
        return Collections.binarySearch(this, paramT, this.comparator) > -1;
    }
}

