/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.mvc;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.JtwigTemplate;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.functions.repository.AbstractFunctionRepository;
import com.lyncode.jtwig.functions.repository.WebFunctionRepository;
import com.lyncode.jtwig.mvc.JtwigViewResolver;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.resource.WebJtwigResource;
import com.lyncode.jtwig.tree.content.Content;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class JtwigView
extends AbstractTemplateView {
    private static Logger log = LogManager.getLogger(JtwigView.class);
    private Map<String, Content> compiledTemplates = new HashMap<String, Content>();

    protected String getEncoding() {
        return this.getViewResolver().getEncoding();
    }

    protected String getTheme() {
        return this.getViewResolver().getTheme();
    }

    private JtwigViewResolver getViewResolver() {
        return (JtwigViewResolver)((Object)this.getApplicationContext().getBean(JtwigViewResolver.class));
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)ex);
        }
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JtwigModelMap modelMap = new JtwigModelMap().add(model).add("theme", (Object)this.getTheme()).add("request", (Object)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rendering Jtwig template [" + this.getUrl() + "] in JtwigView '" + this.getBeanName() + "'"));
            log.debug((Object)("Model: " + modelMap));
        }
        response.setContentType(this.getContentType());
        if (this.getEncoding() != null) {
            response.setCharacterEncoding(this.getEncoding());
        }
        this.getContent(request).render((OutputStream)response.getOutputStream(), new JtwigContext(modelMap, (AbstractFunctionRepository)WebFunctionRepository.getInstance()));
    }

    public Content getContent(HttpServletRequest request) throws CompileException, ParseException {
        if (this.getViewResolver().isCached()) {
            if (!this.compiledTemplates.containsKey(this.getUrl())) {
                this.compiledTemplates.put(this.getUrl(), this.getCompiledJtwigTemplate(request));
            }
            return this.compiledTemplates.get(this.getUrl());
        }
        return this.getCompiledJtwigTemplate(request);
    }

    private Content getCompiledJtwigTemplate(HttpServletRequest request) throws ParseException, CompileException {
        return new JtwigTemplate((JtwigResource)new WebJtwigResource(request.getSession().getServletContext(), this.getUrl())).compile();
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return JtwigView.this.getBeanName();
        }

        public ServletContext getServletContext() {
            return JtwigView.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

