/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.mvc;

import com.lyncode.jtwig.mvc.JtwigView;
import com.lyncode.jtwig.services.api.theme.ThemePrefixResolver;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class JtwigViewResolver
extends AbstractTemplateViewResolver {
    private String encoding;
    private String theme;
    private boolean cached;
    private ThemePrefixResolver prefixResolver = JtwigViewResolver.defaultPrefixResolver();

    private static ThemePrefixResolver defaultPrefixResolver() {
        return new ThemePrefixResolver(){

            @Override
            public String getPrefix(String prefix, String theme) {
                return new File(prefix, theme).getPath();
            }
        };
    }

    public JtwigViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    protected Class<?> requiredViewClass() {
        return JtwigView.class;
    }

    protected String getPrefix() {
        if (this.hasTheme()) {
            return this.getPrefixWithTheme();
        }
        return super.getPrefix();
    }

    private String getPrefixWithTheme() {
        String prefix = this.prefixResolver.getPrefix(super.getPrefix(), this.getTheme());
        if (super.getPrefix().endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        return prefix;
    }

    public boolean isCached() {
        return this.cached;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean hasTheme() {
        return StringUtils.isNotBlank((CharSequence)this.theme);
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

