/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.resource;

import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.File;
import java.io.InputStream;
import javax.servlet.ServletContext;

public class WebJtwigResource
implements JtwigResource {
    private ServletContext servletContext;
    private String url;

    public WebJtwigResource(ServletContext servletContext, String url) {
        this.servletContext = servletContext;
        this.url = url;
    }

    public InputStream retrieve() throws ResourceException {
        InputStream resourceAsStream = this.servletContext.getResourceAsStream(this.url);
        if (resourceAsStream == null) {
            throw new ResourceException("Resource " + this.url + " not found");
        }
        return resourceAsStream;
    }

    public JtwigResource resolve(String relativePath) throws ResourceException {
        String relativeUrl = new File(new File(this.url).getParent(), relativePath).getPath();
        return new WebJtwigResource(this.servletContext, relativeUrl);
    }
}

