/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.services.impl.assets;

import com.lyncode.jtwig.exceptions.AssetResolveException;
import com.lyncode.jtwig.mvc.JtwigViewResolver;
import com.lyncode.jtwig.services.api.assets.AssetResolver;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ViewResolver;

public class BaseAssetResolver
implements AssetResolver {
    private String prefix;
    @Autowired
    private ViewResolver viewResolver;

    @Override
    public String resolve(String asset) throws AssetResolveException {
        if (this.prefix == null) {
            this.prefix = "/";
        }
        if (!(this.viewResolver instanceof JtwigViewResolver)) {
            throw new AssetResolveException("The view resolver must be a JtwigViewResolver");
        }
        if (((JtwigViewResolver)this.viewResolver).hasTheme()) {
            return new File(new File(this.prefix, ((JtwigViewResolver)this.viewResolver).getTheme()), asset).getPath();
        }
        return new File(this.prefix, asset).getPath();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

