/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.junit.runner;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.lyncode.pal.PalTest;
import com.lyncode.pal.junit.runner.TableRunner;
import com.lyncode.pal.model.PalTestIndex;
import com.lyncode.pal.model.PalTestScenario;
import com.lyncode.pal.model.Status;
import com.lyncode.pal.parser.impl.ClassFileLocatorImpl;
import com.lyncode.pal.parser.impl.MethodCodeExtractorImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class PalRunner
extends TableRunner {
    private static final MethodCodeExtractorImpl methodCodeExtractor = new MethodCodeExtractorImpl(new ClassFileLocatorImpl());
    private PalTestScenario currentScenario = null;

    public static MethodCodeExtractorImpl extractor() {
        return methodCodeExtractor;
    }

    public PalRunner(Class<?> typeClass) throws InitializationError {
        super(typeClass);
        if (!PalTest.class.isAssignableFrom(typeClass)) {
            throw new IllegalStateException(String.format("Test should extend %s class", PalTest.class.getSimpleName()));
        }
        PalTestIndex.add(typeClass);
        super.setScheduler(new RunnerScheduler(){

            public void schedule(Runnable childStatement) {
                childStatement.run();
            }

            public void finished() {
                PalTestIndex.render();
            }
        });
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        return new ArrayList<FrameworkMethod>(Collections2.filter(super.computeTestMethods(), PalRunner.isNotEvaluateMethod()));
    }

    private static Predicate<FrameworkMethod> isNotEvaluateMethod() {
        return new Predicate<FrameworkMethod>(){

            public boolean apply(@Nullable FrameworkMethod input) {
                return !input.getName().equals("evaluate");
            }
        };
    }

    public void run(RunNotifier notifier) {
        ResultListener listener = new ResultListener();
        notifier.addListener((RunListener)listener);
        super.run(notifier);
        notifier.removeListener((RunListener)listener);
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        final Statement statement = super.methodInvoker(method, test);
        return new Statement(){

            public void evaluate() throws Throwable {
                PalRunner.this.currentScenario = PalTestIndex.scenario((TableRunner.DecoratingFrameworkMethod)method);
                if (!(test instanceof PalTest)) {
                    throw new IllegalStateException(String.format("Test should extend %s class", PalTest.class.getSimpleName()));
                }
                PalTest palTest = (PalTest)test;
                PalRunner.this.currentScenario.communicationStore(palTest.communications()).givensStore(palTest.givens()).markAs(Status.Passed).startTimer();
                statement.evaluate();
                PalRunner.this.currentScenario.stopTimer();
            }
        };
    }

    private final class ResultListener
    extends RunListener {
        private ResultListener() {
        }

        public void testFailure(Failure failure) throws Exception {
            if (PalRunner.this.currentScenario != null) {
                PalRunner.this.currentScenario.fail(failure.getException());
                PalRunner.this.currentScenario.stopTimer();
            }
            super.testFailure(failure);
        }

        public void testRunFinished(Result result) throws Exception {
            if (PalRunner.this.currentScenario != null && result.wasSuccessful()) {
                PalRunner.this.currentScenario.markAs(Status.Passed);
            }
            super.testRunFinished(result);
        }
    }
}

