/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.junit.runner;

import com.lyncode.pal.junit.annotations.Row;
import com.lyncode.pal.junit.annotations.Table;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class TableRunner
extends BlockJUnit4ClassRunner {
    private Filter filter;

    public TableRunner(Class<?> typeClass) throws InitializationError {
        super(typeClass);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
    }

    protected List<FrameworkMethod> getChildren() {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        List<FrameworkMethod> methods = this.computeTestMethods();
        for (FrameworkMethod method : methods) {
            Table annotation = (Table)method.getAnnotation(Table.class);
            if (annotation == null) {
                result.add(new DecoratingFrameworkMethod(method, null));
                continue;
            }
            for (Row row : annotation.value()) {
                result.add(new DecoratingFrameworkMethod(method, row));
            }
        }
        return result;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.filter == null) {
            return super.computeTestMethods();
        }
        List list = super.computeTestMethods();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.filter.shouldRun(this.describeChild((FrameworkMethod)iterator.next()))) continue;
            iterator.remove();
        }
        return list;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.filter = filter;
        if (this.computeTestMethods().isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public static class DecoratingFrameworkMethod
    extends FrameworkMethod {
        private final Row row;

        public DecoratingFrameworkMethod(FrameworkMethod method, Row row) {
            super(method.getMethod());
            this.row = row;
        }

        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            if (this.row != null) {
                return super.invokeExplosively(target, (Object[])this.row.value());
            }
            return super.invokeExplosively(target, (Object[])null);
        }

        public String getName() {
            if (this.row == null) {
                return super.getName();
            }
            ArrayList values = new ArrayList();
            Collections.addAll(values, this.row.value());
            return super.getName() + " (" + StringUtils.join(values, (String)", ") + ")";
        }

        public Row getRow() {
            return this.row;
        }
    }
}

