/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.model;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.pal.junit.annotations.Row;
import com.lyncode.pal.junit.annotations.Table;
import com.lyncode.pal.junit.runner.TableRunner;
import com.lyncode.pal.model.PalTestRowScenario;
import com.lyncode.pal.model.PalTestScenario;
import com.lyncode.pal.model.Status;
import com.lyncode.pal.render.model.TestCaseModel;
import com.lyncode.pal.utils.JtwigUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;

public class PalTestCase
implements Comparable<PalTestCase> {
    private final Class<?> typeClass;
    private List<PalTestScenario> scenarios = new ArrayList<PalTestScenario>();

    public PalTestCase(Class<?> typeClass) {
        this.typeClass = typeClass;
        for (Method method : typeClass.getDeclaredMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            FrameworkMethod frameworkMethod = new FrameworkMethod(method);
            Table table = (Table)frameworkMethod.getAnnotation(Table.class);
            if (table != null) {
                for (Row row : table.value()) {
                    this.scenarios.add(new PalTestRowScenario(method, row));
                }
                continue;
            }
            this.scenarios.add(new PalTestScenario(method));
        }
    }

    public PalTestScenario scenario(TableRunner.DecoratingFrameworkMethod method) {
        for (PalTestScenario scenario : this.scenarios) {
            if (!scenario.generatedBy(method)) continue;
            return scenario;
        }
        throw new RuntimeException("Unable to find the scenario you are looking for!");
    }

    public Package getPackage() {
        return this.typeClass.getPackage();
    }

    @Override
    public int compareTo(PalTestCase o) {
        return new Integer(this.typeClass.getPackage().getName().length()).compareTo(o.typeClass.getPackage().getName().length());
    }

    public int count(Status status) {
        int sum = 0;
        for (PalTestScenario scenario : this.scenarios) {
            if (!scenario.isMarkedAs(status)) continue;
            ++sum;
        }
        return sum;
    }

    public Class<?> type() {
        return this.typeClass;
    }

    public void render() {
        File outputFile = new File(FileUtils.getTempDirectory(), String.format("%s.html", this.type().getName()));
        String templateLocation = "/pal/templates/pages/test.twig.html";
        try {
            JtwigUtils.renderTo(outputFile, templateLocation, new JtwigModelMap().withModelAttribute("test", (Object)new TestCaseModel(this)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<PalTestScenario> scenarios() {
        return this.scenarios;
    }
}

