/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.model;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.pal.model.PalTestCase;
import com.lyncode.pal.model.Status;
import com.lyncode.pal.render.model.GroupModel;
import com.lyncode.pal.utils.JtwigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.io.FileUtils;

public class PalTestGroup
implements Comparable<PalTestGroup> {
    private final String aPackage;
    private final List<PalTestCase> testCases;

    public static Collection<PalTestGroup> fromTestCases(Collection<PalTestCase> testCases) {
        HashMap packages = new HashMap();
        for (PalTestCase testCase : testCases) {
            String name = testCase.getPackage().getName();
            if (!packages.containsKey(name)) {
                packages.put(name, new ArrayList());
            }
            ((List)packages.get(name)).add(testCase);
        }
        PriorityQueue<PalTestGroup> groups = new PriorityQueue<PalTestGroup>();
        for (String aPackage : packages.keySet()) {
            groups.add(new PalTestGroup(aPackage, (List)packages.get(aPackage)));
        }
        return groups;
    }

    public PalTestGroup(String aPackage, List<PalTestCase> palTestCases) {
        this.aPackage = aPackage;
        this.testCases = palTestCases;
    }

    @Override
    public int compareTo(PalTestGroup o) {
        return this.aPackage.compareTo(o.aPackage);
    }

    public int count(Status status) {
        int sum = 0;
        for (PalTestCase testCase : this.testCases) {
            sum += testCase.count(status);
        }
        return sum;
    }

    public void render() {
        File outputFile = new File(FileUtils.getTempDirectory(), String.format("%s.html", this.getPackage()));
        String templateLocation = "/pal/templates/pages/group.twig.html";
        try {
            JtwigUtils.renderTo(outputFile, templateLocation, new JtwigModelMap().withModelAttribute("group", (Object)new GroupModel(this)));
            for (PalTestCase testCase : this.testCases) {
                testCase.render();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<PalTestCase> testCases() {
        return this.testCases;
    }

    public String getPackage() {
        return this.aPackage;
    }
}

