/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.model;

import com.lyncode.pal.junit.runner.PalRunner;
import com.lyncode.pal.junit.runner.TableRunner;
import com.lyncode.pal.model.Status;
import com.lyncode.pal.model.TestSpecification;
import com.lyncode.pal.syntax.flow.CommunicationStore;
import com.lyncode.pal.syntax.given.GivensStore;
import com.lyncode.pal.utils.SubtleWordUtils;
import com.lyncode.pal.utils.TimeWatch;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class PalTestScenario
implements Comparable<PalTestScenario> {
    private final Method method;
    private Status status = Status.Ignored;
    private long elapsedTime = -1L;
    private Throwable exception;
    private CommunicationStore communicationStore;
    private GivensStore givensStore;
    private TimeWatch watch;
    private TestSpecification testSpecification;

    public PalTestScenario(Method method) {
        this.method = method;
    }

    public boolean generatedBy(TableRunner.DecoratingFrameworkMethod method) {
        return method.getMethod().equals(this.method);
    }

    public PalTestScenario markAs(Status status) {
        this.status = status;
        return this;
    }

    public PalTestScenario fail(Throwable exception) {
        this.exception = exception;
        this.markAs(Status.Failed);
        return this;
    }

    public boolean isMarkedAs(Status status) {
        return this.status == status;
    }

    public Status status() {
        return this.status;
    }

    public String name() {
        return SubtleWordUtils.sentencify(this.method.getName(), true);
    }

    public long timeElapsed() {
        return this.elapsedTime;
    }

    @Override
    public int compareTo(PalTestScenario o) {
        return o.status().getViewPriority() - this.status().getViewPriority();
    }

    public String specification() {
        try {
            return this.extractSpecification().text().toString();
        }
        catch (Exception e) {
            return String.format("Error: Unable to parse Java Class %s", this.method.getDeclaringClass().getName());
        }
    }

    public TestSpecification extractSpecification() {
        if (this.testSpecification == null) {
            try {
                this.testSpecification = PalRunner.extractor().extract(this.method);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error: Unable to parse Java Class %s", this.method.getDeclaringClass().getName()), e);
            }
        }
        return this.testSpecification;
    }

    public GivensStore givensStore() {
        return this.givensStore;
    }

    public CommunicationStore communicationStore() {
        return this.communicationStore;
    }

    public PalTestScenario startTimer() {
        this.watch = TimeWatch.start();
        return this;
    }

    public PalTestScenario stopTimer() {
        this.elapsedTime = this.watch.time(TimeUnit.MILLISECONDS);
        return this;
    }

    public PalTestScenario communicationStore(CommunicationStore communications) {
        this.communicationStore = communications;
        return this;
    }

    public PalTestScenario givensStore(GivensStore givens) {
        this.givensStore = givens;
        return this;
    }
}

