/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.parser.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.lyncode.pal.parser.api.ClassFileLocator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ClassFileLocatorImpl
implements ClassFileLocator {
    private Map<String, List<File>> roots = new TreeMap<String, List<File>>();

    @Override
    public File locationOf(Class<?> typeClass) throws FileNotFoundException {
        String child = this.pathFor(typeClass);
        List<File> roots = this.roots(typeClass);
        for (File file : roots) {
            File fileTry = new File(file, child);
            if (!fileTry.exists()) continue;
            return fileTry;
        }
        throw new FileNotFoundException();
    }

    private String pathFor(Class<?> typeClass) {
        return StringUtils.join((Object[])typeClass.getName().split("\\."), (String)File.separator) + ".java";
    }

    private List<File> roots(Class<?> typeClass) {
        String[] split = typeClass.getName().split("\\.");
        if (split.length > 0) {
            return this.roots(split[0]);
        }
        throw new RuntimeException("Buddy only supports test classes stored in some package (empty package not allowed)");
    }

    private List<File> roots(String root) {
        if (!this.roots.containsKey(root)) {
            this.roots.put(root, this.locate(new File("."), root));
        }
        return this.roots.get(root);
    }

    private List<File> locate(File start, final String root) {
        Collection transform = Collections2.transform(Arrays.asList(start.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })), (Function)new Function<File, List<File>>(){

            @Nullable
            public List<File> apply(@Nullable File input) {
                return input.getName().equals(root) ? Arrays.asList(input.getParentFile()) : ClassFileLocatorImpl.this.locate(input, root);
            }
        });
        ArrayList<File> result = new ArrayList<File>();
        for (List files : transform) {
            for (File file : files) {
                result.add(file);
            }
        }
        return result;
    }
}

