/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.parser.impl;

import com.lyncode.pal.model.TestSpecification;
import com.lyncode.pal.parser.api.ClassFileLocator;
import com.lyncode.pal.parser.api.MethodCodeExtractor;
import com.lyncode.pal.parser.impl.java8.Java8Lexer;
import com.lyncode.pal.parser.impl.java8.Java8MethodSpecificationListener;
import com.lyncode.pal.parser.impl.java8.Java8Parser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.io.IOUtils;

public class MethodCodeExtractorImpl
implements MethodCodeExtractor {
    private final ClassFileLocator locator;
    private static final Map<String, String> testContent = new HashMap<String, String>();

    public MethodCodeExtractorImpl(ClassFileLocator locator) {
        this.locator = locator;
    }

    @Override
    public TestSpecification extract(Method method) throws IOException, NoSuchMethodException {
        Java8Lexer lexer = new Java8Lexer((CharStream)new ANTLRInputStream((InputStream)new ByteArrayInputStream(this.getContent(method).getBytes())));
        Java8Parser.CompilationUnitContext tree = new Java8Parser((TokenStream)new CommonTokenStream((TokenSource)lexer)).compilationUnit();
        ParseTreeWalker walker = new ParseTreeWalker();
        Java8MethodSpecificationListener listener = new Java8MethodSpecificationListener(method);
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        TestSpecification result = listener.result();
        return result;
    }

    private synchronized String getContent(Method method) throws IOException {
        if (!testContent.containsKey(method.getDeclaringClass().getName())) {
            FileInputStream stream = new FileInputStream(this.locator.locationOf(method.getDeclaringClass()));
            testContent.put(method.getDeclaringClass().getName(), IOUtils.toString((InputStream)stream));
            stream.close();
        }
        return testContent.get(method.getDeclaringClass().getName());
    }
}

