/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.parser.impl.java8;

import com.lyncode.pal.model.TestSpecification;
import com.lyncode.pal.parser.impl.java8.Java8BaseListener;
import com.lyncode.pal.parser.impl.java8.Java8Parser;
import com.lyncode.pal.utils.SubtleWordUtils;
import java.lang.reflect.Method;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Java8MethodSpecificationListener
extends Java8BaseListener {
    private boolean record = false;
    private boolean recordLine = false;
    private boolean firstInTheLine = true;
    private final Method method;
    private TestSpecification specification = new TestSpecification();

    public Java8MethodSpecificationListener(Method method) {
        this.method = method;
    }

    public TestSpecification result() {
        return this.specification;
    }

    @Override
    public void enterMethodDeclaration(@NotNull Java8Parser.MethodDeclarationContext ctx) {
        if (ctx.Identifier().getText().equals(this.method.getName())) {
            if (ctx.formalParameters().formalParameterList() == null) {
                if (this.method.getParameterTypes().length == 0) {
                    this.record = true;
                }
            } else if (this.method.getParameterTypes().length == ctx.formalParameters().formalParameterList().formalParameter().size()) {
                this.record = true;
                this.specification.parameters(ctx.formalParameters().formalParameterList().formalParameter());
            }
        }
    }

    @Override
    public void exitMethodDeclaration(@NotNull Java8Parser.MethodDeclarationContext ctx) {
        if (this.record) {
            this.record = false;
        }
    }

    @Override
    public void enterStatementExpression(@NotNull Java8Parser.StatementExpressionContext ctx) {
        if (this.record) {
            this.specification.text().append("<p class=\"line\">");
            this.firstInTheLine = true;
            this.recordLine = true;
        }
    }

    @Override
    public void exitStatementExpression(@NotNull Java8Parser.StatementExpressionContext ctx) {
        if (this.record) {
            this.specification.text().append(".</p>\n");
            this.recordLine = false;
        }
    }

    @Override
    public void enterPrimary(@NotNull Java8Parser.PrimaryContext ctx) {
        if (this.record && ctx.getChild(0) instanceof TerminalNode) {
            if (this.firstInTheLine) {
                this.specification.text().append("<span class=\"first\">").append(SubtleWordUtils.sentencify(ctx.getText(), true)).append("</span>");
                this.firstInTheLine = false;
            } else {
                String text = ctx.getText();
                if (text.matches("[_A-Z][_A-Z1-9]*")) {
                    this.specification.text().append(" <span class=\"constant\">").append(text).append("</span>");
                } else {
                    int parameter = this.parameterPosition(ctx.Identifier().getText());
                    if (parameter != -1) {
                        this.specification.text().append(" ").append("<span class=\"parameter\">%" + parameter + "s</span>");
                    } else {
                        this.specification.text().append(" ").append(SubtleWordUtils.sentencify(text, false));
                    }
                }
            }
        }
    }

    @Override
    public void enterLiteral(@NotNull Java8Parser.LiteralContext ctx) {
        if (this.record) {
            this.specification.text().append(" <span class=\"literal\">").append(ctx.getText()).append("</span>");
        }
    }

    @Override
    public void visitTerminal(@NotNull TerminalNode node) {
        if (this.recordLine && !this.isInstanceOf(node.getParent(), Java8Parser.LiteralContext.class, Java8Parser.PrimaryContext.class) && !this.isSymbol(node.getText())) {
            this.specification.text().append(" ").append(SubtleWordUtils.sentencify(node.getText(), false));
        }
    }

    private int parameterPosition(String text) {
        int position = 1;
        for (Java8Parser.FormalParameterContext formalParameterContext : this.specification.parameters()) {
            if (formalParameterContext.variableDeclaratorId().getText().equals(text)) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    private boolean isSymbol(String text) {
        return text.matches("[,\\(\\)\\.\\[\\]]");
    }

    private boolean isInstanceOf(Object o, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(o)) continue;
            return true;
        }
        return false;
    }
}

