/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.render.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.lyncode.pal.model.PalTestCase;
import com.lyncode.pal.model.PalTestGroup;
import com.lyncode.pal.model.Status;
import com.lyncode.pal.render.model.TestCaseModel;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class GroupModel {
    private final PalTestGroup palTestGroup;
    private final ArrayList<TestCaseModel> tests;

    public GroupModel(PalTestGroup palTestGroup) {
        this.palTestGroup = palTestGroup;
        this.tests = new ArrayList(Collections2.transform(palTestGroup.testCases(), (Function)new Function<PalTestCase, TestCaseModel>(){

            @Nullable
            public TestCaseModel apply(@Nullable PalTestCase input) {
                return new TestCaseModel(input);
            }
        }));
    }

    public String name() {
        return this.palTestGroup.getPackage();
    }

    public int count(String status) {
        return this.palTestGroup.count(Status.valueOf(status));
    }

    public boolean hasErrors() {
        return this.palTestGroup.count(Status.Failed) > 0;
    }

    public ArrayList<TestCaseModel> getTests() {
        return this.tests;
    }
}

