/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.pal.render.model;

import com.lyncode.pal.model.PalTestScenario;
import com.lyncode.pal.result.group.Group;
import com.lyncode.pal.result.group.communication.CommunicationDiagramGroup;
import com.lyncode.pal.result.group.given.GivensGroup;
import com.lyncode.pal.result.group.specification.SpecificationGroup;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ScenarioModel
implements Comparable<ScenarioModel> {
    private final PalTestScenario scenario;

    public ScenarioModel(PalTestScenario scenario) {
        this.scenario = scenario;
    }

    public String prettyStatus() {
        switch (this.scenario.status()) {
            case Failed: {
                return "danger";
            }
            case Passed: {
                return "success";
            }
        }
        return "default";
    }

    public String status() {
        return this.scenario.status().name();
    }

    public String name() {
        return this.scenario.name();
    }

    public String id() {
        return this.scenario.name().replaceAll("\\s", "");
    }

    public List<Group> groups() {
        return Arrays.asList(new SpecificationGroup(this.scenario.specification()), new GivensGroup(this.scenario.givensStore()), new CommunicationDiagramGroup(this.scenario.communicationStore(), UUID.randomUUID().toString()));
    }

    public String time() {
        long milliseconds = this.scenario.timeElapsed();
        if ((long)Unit.Minutes.getDivisionFromMillis() < milliseconds) {
            return this.plural(milliseconds / (long)Unit.Minutes.getDivisionFromMillis(), "h");
        }
        if ((long)Unit.Seconds.getDivisionFromMillis() < milliseconds) {
            return this.plural(milliseconds / (long)Unit.Seconds.getDivisionFromMillis(), "m");
        }
        if ((long)Unit.Milliseconds.getDivisionFromMillis() < milliseconds) {
            return this.plural(milliseconds / (long)Unit.Milliseconds.getDivisionFromMillis(), "s");
        }
        if (milliseconds <= 0L) {
            return "---";
        }
        return this.plural(milliseconds, "ms");
    }

    private String plural(long value, String hour) {
        return String.format("%d%s", value, value == 1L ? hour : hour);
    }

    @Override
    public int compareTo(ScenarioModel o) {
        return this.scenario.compareTo(o.scenario);
    }

    private static enum Unit {
        Milliseconds(1000),
        Seconds(60000),
        Minutes(3600000),
        Hours(86400000);

        private final int divisionFromMillis;

        private Unit(int divisionFromMillis) {
            this.divisionFromMillis = divisionFromMillis;
        }

        public int getDivisionFromMillis() {
            return this.divisionFromMillis;
        }
    }
}

