/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.test.matchers.xml;

import com.lyncode.builder.MapBuilder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class XPathMatchers {
    private static final String DEFAULT_PREFIX = "defprefix";

    private static String replaceXpath(String xpath) {
        int offset = 0;
        String newXpath = "";
        Pattern pattern = Pattern.compile("/[^/]+");
        Matcher matcher = pattern.matcher(xpath);
        while (matcher.find()) {
            if (matcher.start() > offset) {
                newXpath = newXpath + xpath.substring(offset, matcher.start());
            }
            newXpath = !matcher.group().contains(":") && !matcher.group().startsWith("/@") ? newXpath + "/defprefix:" + matcher.group().substring(1) : newXpath + matcher.group();
            offset = matcher.end() + 1;
        }
        return newXpath;
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value) {
        return new XPathValueMatcher<T>(expression, value);
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value, String defaultNamespace) {
        return XPathMatchers.xPath(XPathMatchers.replaceXpath(expression), value, (MapBuilder<String, String>)new MapBuilder().withPair((Object)DEFAULT_PREFIX, (Object)defaultNamespace));
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value, MapBuilder<String, String> namespaces) {
        return new XPathValueMatcher<T>(expression, value, namespaces);
    }

    public static XPathMatcher hasXPath(String expression) {
        return new XPathMatcher(expression);
    }

    public static XPathMatcher hasXPath(String expression, String defaultNamespace) {
        return new XPathMatcher(XPathMatchers.replaceXpath(expression), (MapBuilder<String, String>)new MapBuilder().withPair((Object)DEFAULT_PREFIX, (Object)defaultNamespace));
    }

    public static XPathMatcher hasXPath(String expression, MapBuilder<String, String> namespaces) {
        return new XPathMatcher(expression, namespaces);
    }

    private static class XPathValueMatcher<T>
    extends BaseMatcher<String> {
        private MapBuilder<String, String> namespaces;
        private org.hamcrest.Matcher<T> value;
        private String expression;

        public XPathValueMatcher(String expression, org.hamcrest.Matcher<T> value) {
            this.value = value;
            this.expression = expression;
        }

        public XPathValueMatcher(String expression, org.hamcrest.Matcher<T> value, MapBuilder<String, String> namespaces) {
            this.value = value;
            this.expression = expression;
            this.namespaces = namespaces;
        }

        public boolean matches(Object o) {
            if (o instanceof String) {
                String input = (String)o;
                try {
                    Document document = DocumentHelper.parseText((String)input);
                    XPath xPath = document.createXPath(this.expression);
                    if (this.namespaces != null) {
                        xPath.setNamespaceURIs(this.namespaces.build());
                    }
                    String evaluatedValue = xPath.valueOf((Object)document);
                    return !xPath.selectNodes((Object)document).isEmpty() && this.value.matches((Object)evaluatedValue);
                }
                catch (DocumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            System.err.println("Incorrect input");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("XPath ").appendValue((Object)this.expression).appendText(" must resolve to ");
            this.value.describeTo(description);
        }
    }

    private static class XPathMatcher
    extends BaseMatcher<String> {
        private String expression;
        private MapBuilder<String, String> contexts;

        public XPathMatcher(String expression) {
            this.expression = expression;
        }

        public XPathMatcher(String expression, MapBuilder<String, String> namespaces) {
            this.expression = expression;
            this.contexts = namespaces;
        }

        public boolean matches(Object o) {
            if (o instanceof String) {
                String input = (String)o;
                try {
                    List list;
                    Document document = DocumentHelper.parseText((String)input);
                    XPath xPath = document.createXPath(this.expression);
                    if (this.contexts != null) {
                        xPath.setNamespaceURIs(this.contexts.build());
                    }
                    boolean contains = !(list = xPath.selectNodes((Object)document)).isEmpty();
                    return contains;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("XML with XPath ").appendValue((Object)this.expression);
        }
    }
}

